/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnReadPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnWritePageCursor;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

final class CursorPool
extends ThreadLocal<CursorSets> {
    private final MuninnPagedFile pagedFile;
    private final long victimPage;
    private final PageCursorTracerSupplier pageCursorTracerSupplier;
    private PageCacheTracer pageCacheTracer;
    private final VersionContextSupplier versionContextSupplier;

    CursorPool(MuninnPagedFile pagedFile, PageCursorTracerSupplier pageCursorTracerSupplier, PageCacheTracer pageCacheTracer, VersionContextSupplier versionContextSupplier) {
        this.pagedFile = pagedFile;
        this.victimPage = pagedFile.pageCache.victimPage;
        this.pageCursorTracerSupplier = pageCursorTracerSupplier;
        this.pageCacheTracer = pageCacheTracer;
        this.versionContextSupplier = versionContextSupplier;
    }

    @Override
    protected CursorSets initialValue() {
        return new CursorSets();
    }

    MuninnReadPageCursor takeReadCursor(long pageId, int pf_flags) {
        CursorSets cursorSets = (CursorSets)this.get();
        MuninnReadPageCursor cursor = cursorSets.readCursors;
        if (cursor != null) {
            cursorSets.readCursors = cursor.nextCursor;
        } else {
            cursor = this.createReadCursor(cursorSets);
        }
        cursor.initialiseFlags(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    private MuninnReadPageCursor createReadCursor(CursorSets cursorSets) {
        MuninnReadPageCursor cursor = new MuninnReadPageCursor(cursorSets, this.victimPage, this.getPageCursorTracer(), this.versionContextSupplier);
        cursor.initialiseFile(this.pagedFile);
        return cursor;
    }

    MuninnWritePageCursor takeWriteCursor(long pageId, int pf_flags) {
        CursorSets cursorSets = (CursorSets)this.get();
        MuninnWritePageCursor cursor = cursorSets.writeCursors;
        if (cursor != null) {
            cursorSets.writeCursors = cursor.nextCursor;
        } else {
            cursor = this.createWriteCursor(cursorSets);
        }
        cursor.initialiseFlags(this.pagedFile, pageId, pf_flags);
        return cursor;
    }

    private MuninnWritePageCursor createWriteCursor(CursorSets cursorSets) {
        MuninnWritePageCursor cursor = new MuninnWritePageCursor(cursorSets, this.victimPage, this.getPageCursorTracer(), this.versionContextSupplier);
        cursor.initialiseFile(this.pagedFile);
        return cursor;
    }

    private PageCursorTracer getPageCursorTracer() {
        PageCursorTracer pageCursorTracer = (PageCursorTracer)this.pageCursorTracerSupplier.get();
        pageCursorTracer.init(this.pageCacheTracer);
        return pageCursorTracer;
    }

    static class CursorSets {
        MuninnReadPageCursor readCursors;
        MuninnWritePageCursor writeCursors;

        CursorSets() {
        }
    }
}

