/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.FileHandle;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private FileSystemAbstraction fs;

    @Override
    public void setFileSystemAbstraction(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
        if (!this.fs.fileExists(file)) {
            if (createIfNotExist) {
                this.fs.create(file).close();
            } else {
                throw new NoSuchFileException(file.getPath(), null, "Cannot map non-existing file");
            }
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, onEviction);
    }

    @Override
    public void syncDevice() {
    }

    @Override
    public Stream<FileHandle> streamFilesRecursive(File directory) throws IOException {
        return SingleFilePageSwapperFactory.streamFilesRecursive(directory.getCanonicalFile(), this.fs);
    }

    @Override
    public void close() {
    }

    public static Stream<FileHandle> streamFilesRecursive(File directory, FileSystemAbstraction fs) throws IOException {
        try {
            List snapshot = SingleFilePageSwapperFactory.streamFilesRecursiveInner(directory, fs).collect(Collectors.toList());
            return snapshot.stream().map(f -> new WrappingFileHandle((File)f, directory, fs));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static Stream<File> streamFilesRecursiveInner(File directory, FileSystemAbstraction fs) {
        File[] files = fs.listFiles(directory);
        if (files == null) {
            if (!fs.fileExists(directory)) {
                throw new UncheckedIOException(new NoSuchFileException(directory.getPath()));
            }
            return Stream.of(directory);
        }
        return Stream.of(files).flatMap(f -> fs.isDirectory((File)f) ? SingleFilePageSwapperFactory.streamFilesRecursiveInner(f, fs) : Stream.of(f));
    }

    @Override
    public String implementationName() {
        return "single";
    }

    @Override
    public int getCachePageSizeHint() {
        return 8192;
    }

    @Override
    public boolean isCachePageSizeHintStrict() {
        return false;
    }

    @Override
    public long getRequiredBufferAlignment() {
        return 1L;
    }

    private static class WrappingFileHandle
    implements FileHandle {
        private final File file;
        private final File baseDirectory;
        private final FileSystemAbstraction fs;

        WrappingFileHandle(File file, File baseDirectory, FileSystemAbstraction fs) {
            this.file = file;
            this.baseDirectory = baseDirectory;
            this.fs = fs;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public File getRelativeFile() {
            int baseLength = this.baseDirectory.getPath().length();
            if (this.baseDirectory.getParent() != null) {
                ++baseLength;
            }
            return new File(this.file.getPath().substring(baseLength));
        }

        @Override
        public void rename(File to, CopyOption ... options) throws IOException {
            File parentFile = this.file.getParentFile();
            this.fs.mkdirs(to.getParentFile());
            this.fs.renameFile(this.file, to, options);
            this.removeEmptyParent(parentFile);
        }

        private void removeEmptyParent(File parentFile) {
            File end = this.baseDirectory.getParentFile();
            while (parentFile != null && !parentFile.equals(end)) {
                File[] files = this.fs.listFiles(parentFile);
                if (files == null || files.length > 0) {
                    return;
                }
                this.fs.deleteFile(parentFile);
                parentFile = parentFile.getParentFile();
            }
        }

        @Override
        public void delete() throws IOException {
            File parentFile = this.file.getParentFile();
            this.fs.deleteFileOrThrow(this.file);
            this.removeEmptyParent(parentFile);
        }
    }
}

