/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.util.function.Consumer;
import org.neo4j.io.fs.FileUtils;

public interface FileHandle {
    public static final Consumer<FileHandle> HANDLE_DELETE = fh -> {
        try {
            fh.delete();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    public static Consumer<FileHandle> handleRenameBetweenDirectories(File from, File to) {
        return fileHandle -> {
            try {
                fileHandle.rename(FileUtils.pathToFileAfterMove(from, to, fileHandle.getFile()), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public File getFile();

    public File getRelativeFile();

    public void rename(File var1, CopyOption ... var2) throws IOException;

    public void delete() throws IOException;
}

