/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neo4j.io.fs.DelegatingFileSystemProvider;
import org.neo4j.io.fs.DelegatingPath;

public abstract class DelegatingFileSystem
extends FileSystem {
    private final FileSystem delegate;
    private final FileSystemProvider provider;

    public DelegatingFileSystem(FileSystem delegate) {
        this.delegate = delegate;
        FileSystemProvider delegateProvider = delegate.provider();
        this.provider = delegateProvider == null ? null : this.createDelegate(delegateProvider);
    }

    public FileSystem getDelegate() {
        return this.delegate;
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.delegate.isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.delegate.getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        final Iterable<Path> rootDirectories = this.delegate.getRootDirectories();
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                final Iterator iterator = rootDirectories.iterator();
                return new Iterator<Path>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Path next() {
                        return DelegatingFileSystem.this.createDelegate((Path)iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.delegate.getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.delegate.supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this.createDelegate(this.delegate.getPath(first, more));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        final PathMatcher matcher = this.delegate.getPathMatcher(syntaxAndPattern);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return matcher.matches(DelegatingPath.getDelegate(path));
            }
        };
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.delegate.getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Path createDelegate(Path path) {
        return new WrappedPath(path, this);
    }

    protected DelegatingFileSystemProvider createDelegate(FileSystemProvider provider) {
        return new WrappedProvider(provider, this);
    }

    public static class WrappedProvider
    extends DelegatingFileSystemProvider {
        private final DelegatingFileSystem fileSystem;

        public WrappedProvider(FileSystemProvider delegate, DelegatingFileSystem fileSystem) {
            super(delegate);
            this.fileSystem = fileSystem;
        }

        @Override
        public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileSystem getFileSystem(URI uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected Path createDelegate(Path path) {
            return this.fileSystem.createDelegate(path);
        }
    }

    public static class WrappedPath
    extends DelegatingPath {
        private final DelegatingFileSystem fileSystem;

        WrappedPath(Path delegate, DelegatingFileSystem fileSystem) {
            super(delegate, fileSystem);
            this.fileSystem = fileSystem;
        }

        @Override
        protected Path createDelegate(Path path) {
            return this.fileSystem.createDelegate(path);
        }
    }
}

