/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.SequenceLock;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.MemoryManager;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPage
extends SequenceLock
implements Page {
    private static final long usageStampOffset = UnsafeUtil.getFieldOffset(MuninnPage.class, (String)"usageStamp");
    private byte cachePageHeader;
    private final MemoryManager memoryManager;
    private long pointer;
    private volatile byte usageStamp;
    public Object nextFree;
    private PageSwapper swapper;
    private long filePageId = -1L;

    public MuninnPage(int cachePageSize, MemoryManager memoryManager) {
        this.cachePageHeader = (byte)(31 - Integer.numberOfLeadingZeros(cachePageSize));
        this.memoryManager = memoryManager;
        this.getCachePageId();
    }

    public int getCachePageId() {
        return System.identityHashCode(this);
    }

    @Override
    public int size() {
        return 1 << (this.cachePageHeader & 0x7F);
    }

    @Override
    public long address() {
        return this.pointer;
    }

    boolean isDirty() {
        return (this.cachePageHeader & 0xFFFFFF80) != 0;
    }

    public void markAsDirty() {
        this.cachePageHeader = (byte)(this.cachePageHeader | 0xFFFFFF80);
    }

    public void markAsClean() {
        this.cachePageHeader = (byte)(this.cachePageHeader & 0x7F);
    }

    public void incrementUsage() {
        byte usage = this.getUsageCounter();
        if (usage < 4) {
            usage = (byte)(usage << 1);
            usage = (byte)(usage + 1);
            usage = (byte)(usage & 0xF);
            UnsafeUtil.putByteVolatile((Object)this, (long)usageStampOffset, (byte)usage);
        }
    }

    public boolean decrementUsage() {
        byte usage = this.getUsageCounter();
        usage = (byte)(usage >>> 1);
        UnsafeUtil.putByteVolatile((Object)this, (long)usageStampOffset, (byte)usage);
        return usage == 0;
    }

    private byte getUsageCounter() {
        return UnsafeUtil.getByteVolatile((Object)this, (long)usageStampOffset);
    }

    public void flush(FlushEventOpportunity flushOpportunity) throws IOException {
        if (this.swapper != null && this.isDirty()) {
            this.doFlush(this.swapper, this.filePageId, flushOpportunity);
        }
    }

    private void doFlush(PageSwapper swapper, long filePageId, FlushEventOpportunity flushOpportunity) throws IOException {
        FlushEvent event = flushOpportunity.beginFlush(filePageId, this.getCachePageId(), swapper);
        try {
            long bytesWritten = swapper.write(filePageId, this);
            this.markAsClean();
            event.addBytesWritten(bytesWritten);
            event.done();
        }
        catch (IOException e) {
            event.done(e);
            throw e;
        }
    }

    public void fault(PageSwapper swapper, long filePageId, PageFaultEvent faultEvent) throws IOException {
        if (this.swapper != null || this.filePageId != -1L) {
            String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s} into cache page %s. Already bound to {filePageId = %s, swapper = %s}.", filePageId, swapper, this.getCachePageId(), this.filePageId, this.swapper);
            throw new IllegalStateException(msg);
        }
        this.filePageId = filePageId;
        long bytesRead = swapper.read(filePageId, this);
        faultEvent.addBytesRead(bytesRead);
        faultEvent.setCachePageId(this.getCachePageId());
        this.swapper = swapper;
    }

    public void evict(EvictionEvent evictionEvent) throws IOException {
        long filePageId = this.filePageId;
        evictionEvent.setCachePageId(this.getCachePageId());
        evictionEvent.setFilePageId(filePageId);
        PageSwapper swapper = this.swapper;
        evictionEvent.setSwapper(swapper);
        this.flush(evictionEvent.flushEventOpportunity());
        this.filePageId = -1L;
        this.swapper = null;
        if (swapper != null) {
            swapper.evicted(filePageId, this);
        }
    }

    public boolean isLoaded() {
        return this.filePageId != -1L;
    }

    public boolean isBoundTo(PageSwapper swapper, long filePageId) {
        return this.swapper == swapper && this.filePageId == filePageId;
    }

    public void initBuffer() {
        if (this.pointer == 0L) {
            this.pointer = this.memoryManager.allocateAligned((long)this.size());
        }
    }

    public long getFilePageId() {
        return this.filePageId;
    }

    @Override
    public String toString() {
        return String.format("MuninnPage@%x[%s -> %x, filePageId = %s%s, swapper = %s, usage counter = %s, %s]", this.hashCode(), this.getCachePageId(), this.pointer, this.filePageId, this.isDirty() ? ", dirty" : "", this.swapper, this.getUsageCounter(), super.toString());
    }
}

