/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageEvictionCallback;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPagedFile
implements PagedFile {
    private static final int translationTableChunkSizePower = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile.translationTableChunkSizePower", 12);
    private static final int translationTableChunkSize = 1 << translationTableChunkSizePower;
    private static final long translationTableChunkSizeMask = translationTableChunkSize - 1;
    private static final int translationTableChunkArrayBase = UnsafeUtil.arrayBaseOffset(MuninnPage[].class);
    private static final int translationTableChunkArrayScale = UnsafeUtil.arrayIndexScale(MuninnPage[].class);
    private static final long headerStateOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"headerState");
    private static final int headerStateRefCountShift = 48;
    private static final int headerStateRefCountMax = Short.MAX_VALUE;
    private static final long headerStateRefCountMask = 0x7FFF000000000000L;
    private static final long headerStateLastPageIdMask = -9223090561878065153L;
    final MuninnPageCache pageCache;
    final int filePageSize;
    final PageCacheTracer tracer;
    volatile Object[][] translationTable;
    final PageSwapper swapper;
    private final CursorPool cursorPool;
    private volatile long headerState;

    MuninnPagedFile(File file, MuninnPageCache pageCache, int filePageSize, PageSwapperFactory swapperFactory, PageCacheTracer tracer, boolean createIfNotExists, boolean truncateExisting) throws IOException {
        this.pageCache = pageCache;
        this.filePageSize = filePageSize;
        this.cursorPool = new CursorPool(this);
        this.tracer = tracer;
        MuninnPageEvictionCallback onEviction = new MuninnPageEvictionCallback(this);
        this.swapper = swapperFactory.createPageSwapper(file, filePageSize, onEviction, createIfNotExists);
        if (truncateExisting) {
            this.swapper.truncate();
        }
        long lastPageId = this.swapper.getLastPageId();
        int initialChunks = 1 + MuninnPagedFile.computeChunkId(lastPageId);
        Object[][] tt = new Object[initialChunks][];
        for (int i = 0; i < initialChunks; ++i) {
            tt[i] = new Object[translationTableChunkSize];
        }
        this.translationTable = tt;
        this.initialiseLastPageId(lastPageId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.file().getName() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags) {
        int lockMask = 3;
        if ((pf_flags & lockMask) == 0) {
            throw new IllegalArgumentException("Must specify either PF_SHARED_WRITE_LOCK or PF_SHARED_READ_LOCK");
        }
        if ((pf_flags & lockMask) == lockMask) {
            throw new IllegalArgumentException("Cannot specify both PF_SHARED_WRITE_LOCK and PF_SHARED_READ_LOCK");
        }
        MuninnPageCursor cursor = (pf_flags & 1) == 0 ? this.cursorPool.takeWriteCursor(pageId, pf_flags) : this.cursorPool.takeReadCursor(pageId, pf_flags);
        cursor.rewind();
        return cursor;
    }

    @Override
    public int pageSize() {
        return this.filePageSize;
    }

    File file() {
        return this.swapper.file();
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this);
    }

    void closeSwapper() throws IOException {
        this.swapper.close();
    }

    @Override
    public void flushAndForce() throws IOException {
        try (MajorFlushEvent flushEvent = this.tracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), false);
            this.syncDevice();
        }
    }

    public void flushAndForceForClose() throws IOException {
        try (MajorFlushEvent flushEvent = this.tracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), true);
            this.syncDevice();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAndForceInternal(FlushEventOpportunity flushOpportunity, boolean forClosing) throws IOException {
        this.pageCache.pauseBackgroundFlushTask();
        MuninnPage[] pages = new MuninnPage[translationTableChunkSize];
        long filePageId = -1L;
        try {
            for (Object[] chunk : this.translationTable) {
                int pagesGrabbed = 0;
                block4: for (int i = 0; i < chunk.length; ++i) {
                    Object element;
                    long offset = MuninnPagedFile.computeChunkOffset(++filePageId);
                    while ((element = UnsafeUtil.getObjectVolatile((Object)chunk, (long)offset)) instanceof MuninnPage) {
                        MuninnPage page = (MuninnPage)element;
                        if (!(forClosing ? page.tryExclusiveLock() : page.tryFreezeLock())) continue;
                        if (page.isBoundTo(this.swapper, filePageId) && page.isDirty()) {
                            pages[pagesGrabbed] = page;
                            ++pagesGrabbed;
                            continue block4;
                        }
                        if (forClosing) {
                            page.unlockExclusive();
                            break;
                        }
                        page.unlockFreeze();
                        break;
                    }
                    if (pagesGrabbed <= 0) continue;
                    pagesGrabbed = this.vectoredFlush(pages, pagesGrabbed, flushOpportunity, forClosing);
                }
                if (pagesGrabbed <= 0) continue;
                this.vectoredFlush(pages, pagesGrabbed, flushOpportunity, forClosing);
            }
            this.swapper.force();
        }
        finally {
            this.pageCache.unpauseBackgroundFlushTask();
        }
    }

    private int vectoredFlush(MuninnPage[] pages, int pagesGrabbed, FlushEventOpportunity flushOpportunity, boolean forClosing) throws IOException {
        FlushEvent flush = null;
        try {
            MuninnPage firstPage = pages[0];
            long startFilePageId = firstPage.getFilePageId();
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].markAsClean();
            }
            flush = flushOpportunity.beginFlush(startFilePageId, firstPage.getCachePageId(), this.swapper);
            long bytesWritten = this.swapper.write(startFilePageId, pages, 0, pagesGrabbed);
            flush.addBytesWritten(bytesWritten);
            flush.addPagesFlushed(pagesGrabbed);
            flush.done();
            int n = 0;
            return n;
        }
        catch (IOException ioe) {
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].markAsDirty();
            }
            if (flush != null) {
                flush.done(ioe);
            }
            throw ioe;
        }
        finally {
            for (int j = 0; j < pagesGrabbed; ++j) {
                if (forClosing) {
                    pages[j].unlockExclusive();
                    continue;
                }
                pages[j].unlockFreeze();
            }
        }
    }

    private void syncDevice() throws IOException {
        this.pageCache.syncDevice();
    }

    @Override
    public long getLastPageId() {
        long state = this.getHeaderState();
        if (this.refCountOf(state) == 0L) {
            throw new IllegalStateException("File has been unmapped: " + this.file().getPath());
        }
        return state & 0x8000FFFFFFFFFFFFL;
    }

    private long getHeaderState() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)headerStateOffset);
    }

    private long refCountOf(long state) {
        return (state & 0x7FFF000000000000L) >>> 48;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        if (lastPageIdFromFile < 0L) {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)Long.MIN_VALUE);
        } else {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)lastPageIdFromFile);
        }
    }

    void increaseLastPageIdTo(long newLastPageId) {
        long update;
        long current;
        long lastPageId;
        do {
            current = this.getHeaderState();
            update = newLastPageId + (current & 0x7FFF000000000000L);
        } while ((lastPageId = current & 0x8000FFFFFFFFFFFFL) < newLastPageId && !UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)update));
    }

    void incrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) + 1L) <= 32767L) continue;
            throw new IllegalStateException("Cannot map file because reference counter would overflow. Maximum reference count is 32767. File is " + this.swapper.file().getAbsolutePath());
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
    }

    boolean decrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) - 1L) >= 0L) continue;
            throw new IllegalStateException("File has already been closed and unmapped. It cannot be closed any further.");
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
        return count == 0L;
    }

    int getRefCount() {
        return (int)this.refCountOf(this.getHeaderState());
    }

    MuninnPage grabFreeAndExclusivelyLockedPage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreeAndExclusivelyLockedPage(faultEvent);
    }

    MuninnPage evictPage(long filePageId) {
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        long chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId);
        Object[] chunk = this.translationTable[chunkId];
        Object element = UnsafeUtil.getAndSetObject((Object)chunk, (long)chunkOffset, null);
        assert (element instanceof MuninnPage) : "Expected to evict a MuninnPage but found " + element;
        return (MuninnPage)element;
    }

    synchronized Object[][] expandCapacity(int maxChunkId) {
        Object[][] tt = this.translationTable;
        if (tt.length <= maxChunkId) {
            int newLength = this.computeNewRootTableLength(maxChunkId);
            Object[][] ntt = new Object[newLength][];
            System.arraycopy(tt, 0, ntt, 0, tt.length);
            for (int i = tt.length; i < ntt.length; ++i) {
                ntt[i] = new Object[translationTableChunkSize];
            }
            tt = ntt;
            this.translationTable = tt;
        }
        return tt;
    }

    private int computeNewRootTableLength(int maxChunkId) {
        return 1 + (int)((double)maxChunkId * 1.1);
    }

    static int computeChunkId(long filePageId) {
        return (int)(filePageId >>> translationTableChunkSizePower);
    }

    static long computeChunkOffset(long filePageId) {
        int index = (int)(filePageId & translationTableChunkSizeMask);
        return UnsafeUtil.arrayOffset((int)index, (int)translationTableChunkArrayBase, (int)translationTableChunkArrayScale);
    }
}

