/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import org.neo4j.concurrent.BinaryLatch;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

abstract class MuninnPageCursor
implements PageCursor {
    private static final int SIZE_OF_BYTE = 1;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_LONG = 8;
    protected MuninnPagedFile pagedFile;
    protected PageSwapper swapper;
    protected PageCacheTracer tracer;
    protected MuninnPage page;
    protected PinEvent pinEvent;
    protected long pageId;
    protected int pf_flags;
    protected long currentPageId;
    protected long nextPageId;
    protected long lockStamp;
    private long pointer;
    private int size;
    private boolean claimed;
    private int offset;

    MuninnPageCursor() {
    }

    public final void initialise(MuninnPagedFile pagedFile, long pageId, int pf_flags) {
        this.pagedFile = pagedFile;
        this.swapper = pagedFile.swapper;
        this.tracer = pagedFile.tracer;
        this.pageId = pageId;
        this.pf_flags = pf_flags;
    }

    public final void markAsClaimed() {
        this.claimed = true;
    }

    public final void assertUnclaimed() {
        if (this.claimed) {
            throw new IllegalStateException("Cannot operate on more than one PageCursor at a time, because it is prone to deadlocks");
        }
    }

    @Override
    public final void rewind() {
        this.nextPageId = this.pageId;
        this.currentPageId = -1L;
    }

    public final void reset(MuninnPage page) {
        this.page = page;
        this.offset = 0;
        this.pointer = page.address();
        this.size = page.size();
        this.pinEvent.setCachePageId(page.getCachePageId());
    }

    @Override
    public final boolean next(long pageId) throws IOException {
        this.nextPageId = pageId;
        return this.next();
    }

    @Override
    public final void close() {
        this.unpinCurrentPage();
        this.pagedFile = null;
        this.claimed = false;
    }

    protected void clearPageState() {
        this.size = 0;
        this.lockStamp = 0L;
        this.page = null;
    }

    @Override
    public final long getCurrentPageId() {
        return this.currentPageId;
    }

    @Override
    public final int getCurrentPageSize() {
        return this.currentPageId == -1L ? -1 : this.pagedFile.pageSize();
    }

    @Override
    public final File getCurrentFile() {
        return this.currentPageId == -1L ? null : this.pagedFile.file();
    }

    protected void pin(long filePageId, boolean exclusive) throws IOException {
        Object item;
        this.pinEvent = this.tracer.beginPin(exclusive, filePageId, this.swapper);
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        long chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId);
        Object[][] tt = this.pagedFile.translationTable;
        if (tt.length <= chunkId) {
            tt = this.expandTranslationTableCapacity(chunkId);
        }
        Object[] chunk = tt[chunkId];
        do {
            if ((item = UnsafeUtil.getObjectVolatile((Object)chunk, (long)chunkOffset)) != null && item.getClass() == MuninnPage.class) {
                MuninnPage page = (MuninnPage)item;
                this.lockPage(page);
                if (page.isBoundTo(this.swapper, filePageId)) continue;
                this.unlockPage(page);
                item = null;
                continue;
            }
            item = item == null ? this.initiatePageFault(filePageId, chunkOffset, chunk) : this.awaitPageFault(item);
        } while (item == null);
        this.pinCursorToPage((MuninnPage)item, filePageId, this.swapper);
    }

    private Object[][] expandTranslationTableCapacity(int chunkId) {
        return this.pagedFile.expandCapacity(chunkId);
    }

    private Object initiatePageFault(long filePageId, long chunkOffset, Object[] chunk) throws IOException {
        BinaryLatch latch = new BinaryLatch();
        MuninnPage item = null;
        if (UnsafeUtil.compareAndSwapObject((Object)chunk, (long)chunkOffset, null, (Object)latch)) {
            item = this.pageFault(filePageId, this.swapper, chunkOffset, chunk, latch);
        }
        return item;
    }

    private Object awaitPageFault(Object item) {
        BinaryLatch latch = (BinaryLatch)item;
        latch.await();
        return null;
    }

    private MuninnPage pageFault(long filePageId, PageSwapper swapper, long chunkOffset, Object[] chunk, BinaryLatch latch) throws IOException {
        long stamp;
        MuninnPage page;
        PageFaultEvent faultEvent = this.pinEvent.beginPageFault();
        try {
            page = this.pagedFile.grabFreePage(faultEvent);
            stamp = page.writeLock();
        }
        catch (Throwable throwable) {
            UnsafeUtil.putObjectVolatile((Object)chunk, (long)chunkOffset, null);
            latch.release();
            faultEvent.done(throwable);
            this.pinEvent.done();
            throw throwable;
        }
        try {
            this.assertPagedFileStillMappedAndGetIdOfLastPage();
            page.initBuffer();
            page.fault(swapper, filePageId, faultEvent);
        }
        catch (Throwable throwable) {
            page.unlockWrite(stamp);
            UnsafeUtil.putObjectVolatile((Object)chunk, (long)chunkOffset, null);
            latch.release();
            faultEvent.done(throwable);
            this.pinEvent.done();
            throw throwable;
        }
        this.convertPageFaultLock(page, stamp);
        UnsafeUtil.putObjectVolatile((Object)chunk, (long)chunkOffset, (Object)page);
        latch.release();
        faultEvent.done();
        return page;
    }

    protected long assertPagedFileStillMappedAndGetIdOfLastPage() {
        return this.pagedFile.getLastPageId();
    }

    protected abstract void unpinCurrentPage();

    protected abstract void convertPageFaultLock(MuninnPage var1, long var2);

    protected abstract void pinCursorToPage(MuninnPage var1, long var2, PageSwapper var4);

    protected abstract void lockPage(MuninnPage var1);

    protected abstract void unlockPage(MuninnPage var1);

    private void checkBounds(int position) {
        if (position > this.size) {
            throw new IndexOutOfBoundsException(this.getOutOfBoundsMessage(position));
        }
    }

    private String getOutOfBoundsMessage(int position) {
        if (this.size > 0) {
            return "Position " + position + " is greater than the upper " + "page size bound of " + this.size;
        }
        return "The PageCursor is not bound to a page. Maybe next() returned false or was not called, or the cursor has been closed.";
    }

    @Override
    public final byte getByte() {
        this.checkBounds(this.offset + 1);
        byte b = UnsafeUtil.getByte((long)(this.pointer + (long)this.offset));
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        this.checkBounds(offset + 1);
        return UnsafeUtil.getByte((long)(this.pointer + (long)offset));
    }

    @Override
    public void putByte(byte value) {
        this.checkBounds(this.offset + 1);
        UnsafeUtil.putByte((long)(this.pointer + (long)this.offset), (byte)value);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        this.checkBounds(offset + 1);
        UnsafeUtil.putByte((long)(this.pointer + (long)offset), (byte)value);
    }

    @Override
    public long getLong() {
        long value = this.getLong(this.offset);
        this.offset += 8;
        return value;
    }

    @Override
    public long getLong(int offset) {
        long value;
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            value = UnsafeUtil.getLong((long)(this.pointer + (long)offset));
            if (!UnsafeUtil.storeByteOrderIsNative) {
                value = Long.reverseBytes(value);
            }
        } else {
            value = this.getLongBigEndian(offset);
        }
        return value;
    }

    private long getLongBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        long a = UnsafeUtil.getByte((long)p) & 0xFF;
        long b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        long c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        long d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        long e = UnsafeUtil.getByte((long)(p + 4L)) & 0xFF;
        long f = UnsafeUtil.getByte((long)(p + 5L)) & 0xFF;
        long g = UnsafeUtil.getByte((long)(p + 6L)) & 0xFF;
        long h = UnsafeUtil.getByte((long)(p + 7L)) & 0xFF;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    @Override
    public void putLong(long value) {
        this.putLong(this.offset, value);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putLong((long)p, (long)(UnsafeUtil.storeByteOrderIsNative ? value : Long.reverseBytes(value)));
        } else {
            this.putLongBigEndian(value, offset);
        }
    }

    private void putLongBigEndian(long value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 56)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 48)));
        UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 40)));
        UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)(value >> 32)));
        UnsafeUtil.putByte((long)(p + 4L), (byte)((byte)(value >> 24)));
        UnsafeUtil.putByte((long)(p + 5L), (byte)((byte)(value >> 16)));
        UnsafeUtil.putByte((long)(p + 6L), (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 7L), (byte)((byte)value));
    }

    @Override
    public int getInt() {
        int i = this.getInt(this.offset);
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt((long)(this.pointer + (long)offset));
            return UnsafeUtil.storeByteOrderIsNative ? x : Integer.reverseBytes(x);
        }
        return this.getIntBigEndian(offset);
    }

    private int getIntBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        int a = UnsafeUtil.getByte((long)p) & 0xFF;
        int b = UnsafeUtil.getByte((long)(p + 1L)) & 0xFF;
        int c = UnsafeUtil.getByte((long)(p + 2L)) & 0xFF;
        int d = UnsafeUtil.getByte((long)(p + 3L)) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public void putInt(int value) {
        this.putInt(this.offset, value);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putInt((long)p, (int)(UnsafeUtil.storeByteOrderIsNative ? value : Integer.reverseBytes(value)));
        } else {
            this.putIntBigEndian(value, offset);
        }
    }

    private void putIntBigEndian(int value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 24)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)(value >> 16)));
        UnsafeUtil.putByte((long)(p + 2L), (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 3L), (byte)((byte)value));
    }

    @Override
    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedInt(int offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public void getBytes(byte[] data) {
        this.getBytes(data, 0, data.length);
    }

    @Override
    public void getBytes(byte[] data, int arrayOffset, int length) {
        this.checkBounds(this.offset + length);
        long address = this.pointer + (long)this.offset;
        for (int i = 0; i < length; ++i) {
            data[arrayOffset + i] = UnsafeUtil.getByte((long)(address + (long)i));
        }
        this.offset += length;
    }

    @Override
    public final void putBytes(byte[] data) {
        this.putBytes(data, 0, data.length);
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        this.checkBounds(this.offset + length);
        long address = this.pointer + (long)this.offset;
        for (int i = 0; i < length; ++i) {
            byte b = data[arrayOffset + i];
            UnsafeUtil.putByte((long)(address + (long)i), (byte)b);
        }
        this.offset += length;
    }

    @Override
    public final short getShort() {
        short s = this.getShort(this.offset);
        this.offset += 2;
        return s;
    }

    @Override
    public short getShort(int offset) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort((long)(this.pointer + (long)offset));
            return UnsafeUtil.storeByteOrderIsNative ? x : Short.reverseBytes(x);
        }
        return this.getShortBigEndian(offset);
    }

    private short getShortBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        short a = (short)(UnsafeUtil.getByte((long)p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte((long)(p + 1L)) & 0xFF);
        return (short)(a << 8 | b);
    }

    @Override
    public void putShort(short value) {
        this.putShort(this.offset, value);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putShort((long)p, (short)(UnsafeUtil.storeByteOrderIsNative ? value : Short.reverseBytes(value)));
        } else {
            this.putShortBigEndian(value, offset);
        }
    }

    private void putShortBigEndian(short value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte((long)p, (byte)((byte)(value >> 8)));
        UnsafeUtil.putByte((long)(p + 1L), (byte)((byte)value));
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = offset;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }
}

