/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.AutoCloseablePageCacheTracerEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.async.AsyncFlushCompletion;
import org.neo4j.io.pagecache.tracing.async.AsyncFlushFailure;

public class DatabaseFlushEvent
implements AutoCloseablePageCacheTracerEvent,
FileFlushEvent.FileFlushEventProvider {
    public static final DatabaseFlushEvent NULL = new DatabaseFlushEvent(FileFlushEvent.NULL, AsyncFlushCompletion.NULL, AsyncFlushFailure.NULL);
    private long pagesFlushed;
    private long ioPerformed;
    private long ioLimit;
    private long timesLimited;
    private long millisLimited;
    private final FileFlushEvent flushEvent;
    private final AsyncFlushCompletion asyncFlushCompletion;
    private final AsyncFlushFailure asyncFlushFailure;

    public DatabaseFlushEvent(FileFlushEvent flushEvent, AsyncFlushCompletion asyncFlushCompletion, AsyncFlushFailure asyncFlushFailure) {
        this.flushEvent = flushEvent;
        this.asyncFlushCompletion = asyncFlushCompletion;
        this.asyncFlushFailure = asyncFlushFailure;
    }

    public void reset() {
        this.pagesFlushed = 0L;
        this.ioPerformed = 0L;
        this.timesLimited = 0L;
        this.millisLimited = 0L;
        this.ioLimit = 0L;
        this.flushEvent.reset();
        this.asyncFlushCompletion.reset();
        this.asyncFlushFailure.reset();
    }

    @Override
    public void close() {
        this.pagesFlushed += this.flushEvent.pagesFlushed() + this.asyncFlushCompletion.pagesFlushed();
        this.ioPerformed += this.flushEvent.ioPerformed() + this.asyncFlushCompletion.ioPerformed() + this.asyncFlushFailure.ioPerformed();
        this.timesLimited += this.flushEvent.limitedNumberOfTimes();
        this.millisLimited += this.flushEvent.limitedMillis();
    }

    @Override
    public FileFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.flushEvent;
    }

    @Override
    public FileFlushEvent beginFileFlush() {
        return this.flushEvent;
    }

    public AsyncFlushCompletion asyncFlushCompletion() {
        return this.asyncFlushCompletion;
    }

    public AsyncFlushFailure asyncFlushFailure() {
        return this.asyncFlushFailure;
    }

    public FileFlushEvent getFlushEvent() {
        return this.flushEvent;
    }

    public long pagesFlushed() {
        return this.pagesFlushed;
    }

    public long ioPerformed() {
        return this.ioPerformed;
    }

    public long getIoLimit() {
        return this.ioLimit;
    }

    public long getTimesLimited() {
        return this.timesLimited;
    }

    public long getMillisLimited() {
        return this.millisLimited;
    }

    public void ioControllerLimit(long configuredLimit) {
        this.ioLimit = configuredLimit;
    }
}

