/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.async.AsyncFailureHandler;
import org.neo4j.io.async.AsyncVectorIOData;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.async.AsyncFlushFailure;

public class AsyncCheckpointFailureHandler
implements AsyncFailureHandler {
    private final DatabaseFlushEvent flushEvent;

    public AsyncCheckpointFailureHandler(DatabaseFlushEvent flushEvent) {
        this.flushEvent = flushEvent;
    }

    @Override
    public void handleFailure(AsyncBlockAccessor accessor, long data, int result, String failureMessage) {
        try (AsyncFlushFailure asyncEvictionFailure = this.flushEvent.asyncFlushFailure();){
            AsyncVectorIOData asyncVectorIO = accessor.asyncVectorIOData(data);
            long[] pages = asyncVectorIO.pages();
            long[] flushStamps = asyncVectorIO.flushStamps();
            for (int i = 0; i < pages.length; ++i) {
                PageList.unlockFlush(pages[i], flushStamps[i], false);
            }
            asyncEvictionFailure.addPagesFailed(pages.length);
            asyncEvictionFailure.reportIO(asyncVectorIO.numberOfBuffers());
        }
    }
}

