/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn.swapper;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.swapper.BlockSwapper;

final class UnsafeBlockSwapper
implements BlockSwapper {
    UnsafeBlockSwapper() {
    }

    @Override
    public int swapIn(StoreChannel channel, long bufferAddress, long fileOffset, int bufferSize) throws IOException {
        int readTotal = 0;
        try {
            int read;
            ByteBuffer buffer = UnsafeBlockSwapper.buffer(bufferAddress, bufferSize);
            while ((read = channel.read(buffer, fileOffset + (long)readTotal)) != -1 && (readTotal += read) < bufferSize) {
            }
            int rest = bufferSize - readTotal;
            if (rest > 0) {
                UnsafeUtil.setMemory((long)(bufferAddress + (long)readTotal), (long)rest, (byte)MuninnPageCache.ZERO_BYTE);
            }
            return readTotal;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(UnsafeBlockSwapper.formatSwapInErrorMessage(fileOffset, bufferSize, readTotal), e);
        }
    }

    @Override
    public void swapOut(StoreChannel channel, long bufferAddress, long fileOffset, int bufferLength) throws IOException {
        try {
            ByteBuffer buffer = UnsafeBlockSwapper.buffer(bufferAddress, bufferLength);
            channel.writeAll(buffer, fileOffset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static ByteBuffer buffer(long buffer, int bufferLength) throws IOException {
        try {
            return UnsafeUtil.newDirectByteBuffer((long)buffer, (int)bufferLength);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    private static String formatSwapInErrorMessage(long fileOffset, int size, int readTotal) {
        return "Read failed after " + readTotal + " of " + size + " bytes from fileOffset " + fileOffset + ".";
    }
}

