/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.ReadableChannel;

public class ByteBufferReadableChannel
implements ReadableChannel {
    private final ByteBuffer buffer;
    private boolean isClosed;

    public ByteBufferReadableChannel(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte get() throws IOException {
        return this.buffer.get();
    }

    @Override
    public short getShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public int getInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public long getLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public float getFloat() throws IOException {
        return this.buffer.getFloat();
    }

    @Override
    public double getDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws IOException {
        this.buffer.get(bytes, 0, length);
    }

    @Override
    public byte getVersion() throws IOException {
        return this.get();
    }

    @Override
    public long getAppendIndex() throws IOException {
        return this.getLong();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int remaining = this.buffer.remaining();
        dst.put(this.buffer);
        return remaining;
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    @Override
    public void beginChecksum() {
    }

    @Override
    public int getChecksum() {
        return 0;
    }

    @Override
    public int endChecksumAndValidate() throws IOException {
        return 0;
    }

    @Override
    public long position() throws IOException {
        return this.buffer.position();
    }

    @Override
    public void position(long byteOffset) throws IOException {
        this.buffer.position(Math.toIntExact(byteOffset));
    }
}

