/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.function.ThrowingAction;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.function.ThrowingPredicate;

public final class IOUtils {
    private IOUtils() {
    }

    public static <T extends AutoCloseable> void closeAll(Collection<T> closeables) throws IOException {
        IOUtils.close(IOException::new, closeables);
    }

    public static <T extends AutoCloseable> void closeAllUnchecked(Collection<T> closeables) {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void closeAllUnchecked(AutoCloseable ... closeables) {
        IOUtils.closeAllUnchecked(Arrays.asList(closeables));
    }

    public static <T extends AutoCloseable> void closeAllSilently(Collection<T> closeables) {
        IOUtils.close((String msg, Throwable cause) -> null, closeables);
    }

    public static void closeAll(AutoCloseable ... closeables) throws IOException {
        IOUtils.close(IOException::new, closeables);
    }

    public static void closeAllSilently(AutoCloseable ... closeables) {
        IOUtils.close((String msg, Throwable cause) -> null, closeables);
    }

    public static void closeUnchecked(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public static <T extends AutoCloseable, E extends Throwable> void close(BiFunction<String, Throwable, E> constructor, Collection<T> closeables) throws E {
        Throwable closeThrowable = null;
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (closeThrowable == null) {
                    closeThrowable = (Throwable)constructor.apply("Exception closing multiple resources.", e);
                    continue;
                }
                closeThrowable.addSuppressed(e);
            }
        }
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }

    public static <E extends Throwable> void close(BiFunction<String, Throwable, E> constructor, AutoCloseable ... closeables) throws E {
        IOUtils.close(constructor, Arrays.asList(closeables));
    }

    public static <T extends AutoCloseable> void closeFirst(T[] closeables, int count) throws IOException {
        Throwable closeThrowable = null;
        for (int i = 0; i < count; ++i) {
            try {
                T closeable = closeables[i];
                if (closeable == null) continue;
                closeable.close();
                continue;
            }
            catch (Exception e) {
                if (closeThrowable == null) {
                    closeThrowable = new IOException("Exception closing multiple resources.", e);
                    continue;
                }
                closeThrowable.addSuppressed(e);
            }
        }
        if (closeThrowable != null) {
            throw closeThrowable;
        }
    }

    public static Runnable uncheckedRunnable(ThrowingAction<IOException> runnable) {
        return () -> {
            try {
                runnable.apply();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> Predicate<T> uncheckedPredicate(ThrowingPredicate<T, IOException> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> Consumer<T> uncheckedConsumer(ThrowingConsumer<T, IOException> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static LongConsumer uncheckedLongConsumer(ThrowingLongConsumer<IOException> consumer) {
        return l -> {
            try {
                consumer.accept(l);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T, R> Function<T, R> uncheckedFunction(ThrowingFunction<T, R, IOException> consumer) {
        return t -> {
            try {
                return consumer.apply(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static interface ThrowingLongConsumer<E extends Throwable> {
        public void accept(long var1) throws E;
    }

    public static class AutoCloseables<E extends Exception>
    implements AutoCloseable {
        private final BiFunction<String, Throwable, E> constructor;
        private final MutableList<AutoCloseable> autoCloseables;

        public AutoCloseables(BiFunction<String, Throwable, E> constructor, AutoCloseable ... autoCloseables) {
            this.autoCloseables = Lists.mutable.with((Object[])autoCloseables);
            this.constructor = constructor;
        }

        public AutoCloseables(BiFunction<String, Throwable, E> constructor, Iterable<? extends AutoCloseable> autoCloseables) {
            this.autoCloseables = Lists.mutable.withAll(autoCloseables);
            this.constructor = constructor;
        }

        public <T extends AutoCloseable> T add(T autoCloseable) {
            this.autoCloseables.add(autoCloseable);
            return autoCloseable;
        }

        public final void addAll(AutoCloseable ... autoCloseables) {
            this.addAll(Arrays.asList(autoCloseables));
        }

        public void addAll(Iterable<? extends AutoCloseable> autoCloseables) {
            this.autoCloseables.addAllIterable(autoCloseables);
        }

        @Override
        public void close() throws E {
            IOUtils.close(this.constructor, this.autoCloseables);
        }
    }
}

