/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapper;

public class SingleFilePageSwapperFactory
implements PageSwapperFactory {
    private FileSystemAbstraction fs;

    @Override
    public void setFileSystemAbstraction(FileSystemAbstraction fs) {
        this.fs = fs;
    }

    @Override
    public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist) throws IOException {
        if (!this.fs.fileExists(file)) {
            if (createIfNotExist) {
                this.fs.create(file).close();
            } else {
                throw new NoSuchFileException(file.getPath(), null, "Cannot map non-existing file");
            }
        }
        return new SingleFilePageSwapper(file, this.fs, filePageSize, onEviction);
    }

    @Override
    public void syncDevice() {
    }

    @Override
    public String implementationName() {
        return "single";
    }

    @Override
    public int getCachePageSizeHint() {
        return 8192;
    }

    @Override
    public boolean isCachePageSizeHintStrict() {
        return false;
    }

    @Override
    public long getRequiredBufferAlignment() {
        return 1L;
    }
}

