/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;

public abstract class FileLock {
    public static final String STORE_LOCK_FILENAME = "store_lock";
    public static final String NEO_STORE_NAME = "neostore";

    private static FileLock wrapFileChannelLock(StoreChannel channel) throws IOException {
        final java.nio.channels.FileLock lock = channel.tryLock();
        if (lock == null) {
            throw new IOException("Unable to lock " + channel);
        }
        return new FileLock(){

            @Override
            public void release() throws IOException {
                lock.release();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileLock getOsSpecificFileLock(File fileName, StoreChannel channel) throws IOException {
        if (FileUtils.OS_IS_WINDOWS) {
            if (fileName.getName().equals(STORE_LOCK_FILENAME)) {
                return FileLock.getLockFileBasedFileLock(fileName.getParentFile());
            }
            return new PlaceboFileLock();
        }
        if (fileName.getName().equals(NEO_STORE_NAME)) {
            FileLock regular = FileLock.wrapFileChannelLock(channel);
            boolean success = false;
            try {
                FileLock extra = FileLock.getLockFileBasedFileLock(fileName.getParentFile());
                success = true;
                DoubleFileLock doubleFileLock = new DoubleFileLock(regular, extra);
                return doubleFileLock;
            }
            finally {
                if (!success) {
                    regular.release();
                }
            }
        }
        return FileLock.wrapFileChannelLock(channel);
    }

    private static FileLock getLockFileBasedFileLock(File storeDir) throws IOException {
        File lockFile = new File(storeDir, "lock");
        if (!lockFile.exists() && !lockFile.createNewFile()) {
            throw new IOException("Couldn't create lock file " + lockFile.getAbsolutePath());
        }
        FileChannel fileChannel = new RandomAccessFile(lockFile, "rw").getChannel();
        java.nio.channels.FileLock fileChannelLock = null;
        try {
            fileChannelLock = fileChannel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            // empty catch block
        }
        if (fileChannelLock == null) {
            fileChannel.close();
            throw new IOException("Couldn't lock lock file " + lockFile.getAbsolutePath() + " because another process already holds the lock.");
        }
        return new WindowsFileLock(lockFile, fileChannel, fileChannelLock);
    }

    public abstract void release() throws IOException;

    private static class WindowsFileLock
    extends FileLock {
        private final File lockFile;
        private final FileChannel fileChannel;
        private final java.nio.channels.FileLock fileChannelLock;

        public WindowsFileLock(File lockFile, FileChannel fileChannel, java.nio.channels.FileLock lock) {
            this.lockFile = lockFile;
            this.fileChannel = fileChannel;
            this.fileChannelLock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws IOException {
            try {
                this.fileChannelLock.release();
            }
            finally {
                try {
                    this.fileChannel.close();
                }
                finally {
                    if (!FileUtils.deleteFile(this.lockFile)) {
                        Files.delete(this.lockFile.toPath());
                    }
                }
            }
        }
    }

    private static class DoubleFileLock
    extends FileLock {
        private final FileLock regular;
        private final FileLock extra;

        DoubleFileLock(FileLock regular, FileLock extra) {
            this.regular = regular;
            this.extra = extra;
        }

        @Override
        public void release() throws IOException {
            this.regular.release();
            this.extra.release();
        }
    }

    private static class PlaceboFileLock
    extends FileLock {
        private PlaceboFileLock() {
        }

        @Override
        public void release() throws IOException {
        }
    }
}

