/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    private boolean optimisticLock;

    MuninnReadPageCursor() {
    }

    @Override
    protected void unpinCurrentPage() {
        MuninnPage p = this.page;
        this.page = null;
        if (p != null) {
            this.pinEvent.done();
            assert (this.optimisticLock || p.isReadLocked()) : "pinned page wasn't really locked; not even optimistically: " + p;
            if (!this.optimisticLock) {
                p.unlockRead(this.lockStamp);
            }
        }
        this.lockStamp = 0L;
    }

    @Override
    public boolean next() throws IOException {
        this.assertPagedFileStillMapped();
        if (this.nextPageId > this.lastPageId) {
            return false;
        }
        this.unpinCurrentPage();
        this.pin(this.nextPageId, false);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    @Override
    protected void lockPage(MuninnPage page) {
        this.lockStamp = page.tryOptimisticRead();
        this.optimisticLock = true;
    }

    @Override
    protected void unlockPage(MuninnPage page) {
    }

    @Override
    protected void pinCursorToPage(MuninnPage page, long filePageId, PageSwapper swapper) {
        this.reset(page);
        page.incrementUsage();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page, long stamp) {
        stamp = page.tryConvertToReadLock(stamp);
        assert (stamp != 0L) : "Converting a write lock to a read lock should always succeed";
        this.lockStamp = stamp;
        this.optimisticLock = false;
    }

    @Override
    public boolean shouldRetry() throws IOException {
        boolean needsRetry;
        boolean bl = needsRetry = this.optimisticLock && !this.page.validate(this.lockStamp);
        if (needsRetry) {
            this.setOffset(0);
            this.optimisticLock = false;
            this.lockStamp = this.page.readLock();
            if (!this.page.isBoundTo(this.pagedFile.swapper, this.currentPageId)) {
                this.page.unlockRead(this.lockStamp);
                this.page = null;
                this.pin(this.currentPageId, false);
            }
        }
        return needsRetry;
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

