/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.monitoring;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.monitoring.EvictionEvent;
import org.neo4j.io.pagecache.monitoring.EvictionRunEvent;
import org.neo4j.io.pagecache.monitoring.FlushEvent;
import org.neo4j.io.pagecache.monitoring.FlushEventOpportunity;
import org.neo4j.io.pagecache.monitoring.MajorFlushEvent;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.io.pagecache.monitoring.PageFaultEvent;
import org.neo4j.io.pagecache.monitoring.PinEvent;

public class DefaultPageCacheMonitor
implements PageCacheMonitor {
    private static final MethodHandle beginPinMH;
    private static final SwitchPoint beginPinSwitchPoint;
    protected final AtomicLong faults = new AtomicLong();
    protected final AtomicLong evictions = new AtomicLong();
    protected final AtomicLong pins = new AtomicLong();
    protected final AtomicLong unpins = new AtomicLong();
    protected final AtomicLong flushes = new AtomicLong();
    protected final AtomicLong bytesRead = new AtomicLong();
    protected final AtomicLong bytesWritten = new AtomicLong();
    protected final AtomicLong filesMapped = new AtomicLong();
    protected final AtomicLong filesUnmapped = new AtomicLong();
    protected final AtomicLong evictionExceptions = new AtomicLong();
    private final FlushEvent flushEvent = new FlushEvent(){

        @Override
        public void addBytesWritten(int bytes) {
            DefaultPageCacheMonitor.this.bytesWritten.getAndAdd(bytes);
        }

        @Override
        public void done() {
            DefaultPageCacheMonitor.this.flushes.getAndIncrement();
        }

        @Override
        public void done(IOException exception) {
            this.done();
        }
    };
    private final FlushEventOpportunity flushEventOpportunity = new FlushEventOpportunity(){

        @Override
        public FlushEvent beginFlush(long filePageId, int cachePageId, PageSwapper swapper) {
            return DefaultPageCacheMonitor.this.flushEvent;
        }
    };
    private final EvictionEvent evictionEvent = new EvictionEvent(){

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
        }

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheMonitor.this.flushEventOpportunity;
        }

        @Override
        public void threwException(IOException exception) {
            DefaultPageCacheMonitor.this.evictionExceptions.getAndIncrement();
        }

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public void close() {
            DefaultPageCacheMonitor.this.evictions.getAndIncrement();
        }
    };
    private final EvictionRunEvent evictionRunEvent = new EvictionRunEvent(){

        @Override
        public EvictionEvent beginEviction() {
            return DefaultPageCacheMonitor.this.evictionEvent;
        }

        @Override
        public void close() {
        }
    };
    private final PageFaultEvent pageFaultEvent = new PageFaultEvent(){

        @Override
        public void addBytesRead(int bytes) {
            DefaultPageCacheMonitor.this.bytesRead.getAndAdd(bytes);
        }

        @Override
        public void done() {
            DefaultPageCacheMonitor.this.faults.getAndIncrement();
        }

        @Override
        public void done(Throwable throwable) {
            this.done();
        }

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public void setParked(boolean parked) {
        }
    };
    private final PinEvent pinEvent = new PinEvent(){

        @Override
        public void setCachePageId(int cachePageId) {
        }

        @Override
        public PageFaultEvent beginPageFault() {
            return DefaultPageCacheMonitor.this.pageFaultEvent;
        }

        @Override
        public void done() {
            DefaultPageCacheMonitor.this.unpins.getAndIncrement();
        }
    };
    private final MajorFlushEvent majorFlushEvent = new MajorFlushEvent(){

        @Override
        public FlushEventOpportunity flushEventOpportunity() {
            return DefaultPageCacheMonitor.this.flushEventOpportunity;
        }

        @Override
        public void close() {
        }
    };

    public static void enablePinUnpinMonitoring() {
        if (beginPinSwitchPoint != null && !beginPinSwitchPoint.hasBeenInvalidated()) {
            SwitchPoint.invalidateAll(new SwitchPoint[]{beginPinSwitchPoint});
        }
    }

    @Override
    public void mappedFile(File file) {
        this.filesMapped.getAndIncrement();
    }

    @Override
    public void unmappedFile(File file) {
        this.filesUnmapped.getAndIncrement();
    }

    @Override
    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.evictionRunEvent;
    }

    @Override
    public PinEvent beginPin(boolean exclusiveLock, long filePageId, PageSwapper swapper) {
        try {
            return beginPinMH.invokeExact(this);
        }
        catch (Throwable throwable) {
            throw new AssertionError("Unexpected MethodHandle error", throwable);
        }
    }

    private PinEvent beginNullPin() {
        return NULL_PIN_EVENT;
    }

    private PinEvent beginMonitoredPin() {
        this.pins.getAndIncrement();
        return this.pinEvent;
    }

    @Override
    public MajorFlushEvent beginFileFlush(PageSwapper swapper) {
        return this.majorFlushEvent;
    }

    @Override
    public MajorFlushEvent beginCacheFlush() {
        return this.majorFlushEvent;
    }

    @Override
    public long countFaults() {
        return this.faults.get();
    }

    @Override
    public long countEvictions() {
        return this.evictions.get();
    }

    @Override
    public long countPins() {
        return this.pins.get();
    }

    @Override
    public long countUnpins() {
        return this.unpins.get();
    }

    @Override
    public long countFlushes() {
        return this.flushes.get();
    }

    @Override
    public long countBytesRead() {
        return this.bytesRead.get();
    }

    @Override
    public long countBytesWritten() {
        return this.bytesWritten.get();
    }

    @Override
    public long countFilesMapped() {
        return this.filesMapped.get();
    }

    @Override
    public long countFilesUnmapped() {
        return this.filesUnmapped.get();
    }

    @Override
    public long countEvictionExceptions() {
        return this.evictionExceptions.get();
    }

    static {
        try {
            boolean alwaysEnabled = Boolean.getBoolean("org.neo4j.io.pagecache.monitoring.monitorPinUnpin");
            MethodType type = MethodType.methodType(PinEvent.class);
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandle monitoredPinMH = lookup.findVirtual(DefaultPageCacheMonitor.class, "beginMonitoredPin", type);
            if (alwaysEnabled) {
                beginPinMH = monitoredPinMH;
                beginPinSwitchPoint = null;
            } else {
                MethodHandle nullPinMH = lookup.findVirtual(DefaultPageCacheMonitor.class, "beginNullPin", type);
                beginPinSwitchPoint = new SwitchPoint();
                beginPinMH = beginPinSwitchPoint.guardWithTest(nullPinMH, monitoredPinMH);
            }
        }
        catch (Exception e) {
            throw new AssertionError("Unexpected MethodHandle initiation error", e);
        }
    }
}

