/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.jsr166e.StampedLock;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    MuninnWritePageCursor() {
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.page != null) {
            this.pinEvent.done();
            assert (this.page.isWriteLocked()) : "page pinned for writing was not write locked: " + this.page;
            this.page.unlockWrite(this.lockStamp);
            this.page = null;
        }
        this.lockStamp = 0L;
    }

    @Override
    public boolean next() throws IOException {
        this.assertPagedFileStillMapped();
        if (this.nextPageId > this.lastPageId) {
            if ((this.pf_flags & 4) != 0) {
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.unpinCurrentPage();
        this.pin(this.nextPageId);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pin(long filePageId) throws IOException {
        int stripe = (int)(filePageId & (long)MuninnPagedFile.translationTableStripeMask);
        StampedLock translationTableLock = this.pagedFile.translationTableLocks[stripe];
        PrimitiveLongObjectMap<MuninnPage> translationTable = this.pagedFile.translationTables[stripe];
        PageSwapper swapper = this.pagedFile.swapper;
        this.pinEvent = this.pagedFile.monitor.beginPin(true, filePageId, swapper);
        long stamp = translationTableLock.tryOptimisticRead();
        MuninnPage page = (MuninnPage)translationTable.get(filePageId);
        if (!translationTableLock.validate(stamp)) {
            stamp = translationTableLock.readLock();
            try {
                page = (MuninnPage)translationTable.get(filePageId);
            }
            finally {
                translationTableLock.unlockRead(stamp);
            }
        }
        if (page == null) {
            stamp = translationTableLock.writeLock();
            page = (MuninnPage)translationTable.get(filePageId);
            if (page == null) {
                this.pageFault(filePageId, translationTable, translationTableLock, stamp, swapper);
                return;
            }
            translationTableLock.unlockWrite(stamp);
        }
        this.lockStamp = page.writeLock();
        if (page.isBoundTo(swapper, filePageId)) {
            this.pinCursorToPage(page, filePageId, swapper);
            return;
        }
        page.unlockWrite(this.lockStamp);
        stamp = translationTableLock.writeLock();
        page = (MuninnPage)translationTable.get(filePageId);
        if (page != null) {
            this.lockStamp = page.writeLock();
            if (page.isBoundTo(swapper, filePageId)) {
                translationTableLock.unlockWrite(stamp);
                this.pinCursorToPage(page, filePageId, swapper);
                return;
            }
            page.unlockWrite(this.lockStamp);
        }
        this.pageFault(filePageId, translationTable, translationTableLock, stamp, swapper);
    }

    @Override
    protected void pinCursorToPage(MuninnPage page, long filePageId, PageSwapper swapper) {
        this.reset(page);
        this.assertPagedFileStillMapped();
        page.incrementUsage();
        page.markAsDirty();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page, long stamp) {
        this.lockStamp = stamp;
    }

    @Override
    public final boolean shouldRetry() {
        return false;
    }
}

