/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.jsr166e.StampedLock;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    private boolean optimisticLock;

    MuninnReadPageCursor() {
    }

    @Override
    protected void unpinCurrentPage() {
        MuninnPage p = this.page;
        this.page = null;
        if (p != null) {
            this.pinEvent.done();
            assert (this.optimisticLock || p.isReadLocked()) : "pinned page wasn't really locked; not even optimistically: " + p;
            if (!this.optimisticLock) {
                p.unlockRead(this.lockStamp);
            }
        }
        this.lockStamp = 0L;
    }

    @Override
    public boolean next() throws IOException {
        this.assertPagedFileStillMapped();
        if (this.nextPageId > this.lastPageId) {
            return false;
        }
        this.unpinCurrentPage();
        this.pin(this.nextPageId);
        this.currentPageId = this.nextPageId++;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pin(long filePageId) throws IOException {
        int stripe = (int)(filePageId & (long)MuninnPagedFile.translationTableStripeMask);
        StampedLock translationTableLock = this.pagedFile.translationTableLocks[stripe];
        PrimitiveLongObjectMap<MuninnPage> translationTable = this.pagedFile.translationTables[stripe];
        PageSwapper swapper = this.pagedFile.swapper;
        this.pinEvent = this.pagedFile.monitor.beginPin(false, filePageId, swapper);
        long stamp = translationTableLock.tryOptimisticRead();
        MuninnPage page = (MuninnPage)translationTable.get(filePageId);
        if (!translationTableLock.validate(stamp)) {
            stamp = translationTableLock.readLock();
            try {
                page = (MuninnPage)translationTable.get(filePageId);
            }
            finally {
                translationTableLock.unlockRead(stamp);
            }
        }
        if (page == null) {
            stamp = translationTableLock.writeLock();
            page = (MuninnPage)translationTable.get(filePageId);
            if (page == null) {
                this.pageFault(filePageId, translationTable, translationTableLock, stamp, swapper);
                return;
            }
            translationTableLock.unlockWrite(stamp);
        }
        this.lockStamp = page.tryOptimisticRead();
        if (page.isBoundTo(swapper, filePageId)) {
            this.pinCursorToPage(page, filePageId, swapper);
            this.optimisticLock = true;
            return;
        }
        stamp = translationTableLock.writeLock();
        page = (MuninnPage)translationTable.get(filePageId);
        if (page != null) {
            this.lockStamp = page.readLock();
            if (page.isBoundTo(swapper, filePageId)) {
                translationTableLock.unlockWrite(stamp);
                this.pinCursorToPage(page, filePageId, swapper);
                this.optimisticLock = false;
                return;
            }
            page.unlockRead(this.lockStamp);
        }
        this.pageFault(filePageId, translationTable, translationTableLock, stamp, swapper);
    }

    @Override
    protected void pinCursorToPage(MuninnPage page, long filePageId, PageSwapper swapper) {
        this.reset(page);
        page.incrementUsage();
    }

    @Override
    protected void convertPageFaultLock(MuninnPage page, long stamp) {
        stamp = page.tryConvertToReadLock(stamp);
        assert (stamp != 0L) : "Converting a write lock to a read lock should always succeed";
        this.lockStamp = stamp;
        this.optimisticLock = false;
    }

    @Override
    public boolean shouldRetry() throws IOException {
        boolean needsRetry;
        boolean bl = needsRetry = this.optimisticLock && !this.page.validate(this.lockStamp);
        if (needsRetry) {
            this.setOffset(0);
            this.optimisticLock = false;
            this.lockStamp = this.page.readLock();
            if (!this.page.isBoundTo(this.pagedFile.swapper, this.currentPageId)) {
                this.page.unlockRead(this.lockStamp);
                this.page = null;
                this.pin(this.currentPageId);
            }
        }
        return needsRetry;
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

