/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.collection.primitive.PrimitiveLongObjectVisitor;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.muninn.MuninnCursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageEvictionCallback;
import org.neo4j.io.pagecache.impl.muninn.PageFlusher;
import org.neo4j.io.pagecache.impl.muninn.UnsafeUtil;
import org.neo4j.io.pagecache.monitoring.MajorFlushEvent;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.io.pagecache.monitoring.PageFaultEvent;
import org.neo4j.jsr166e.StampedLock;

final class MuninnPagedFile
implements PagedFile {
    private static int stripeFactor = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile.stripeFactor", 10);
    static final int translationTableStripeLevel = 1 << stripeFactor;
    static final int translationTableStripeMask = translationTableStripeLevel - 1;
    private static final long referenceCounterOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, "referenceCounter");
    private static final long lastPageIdOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, "lastPageId");
    final MuninnPageCache pageCache;
    final int pageSize;
    final PageCacheMonitor monitor;
    final PrimitiveLongObjectMap<MuninnPage>[] translationTables;
    final StampedLock[] translationTableLocks;
    final PageSwapper swapper;
    private final MuninnCursorPool cursorPool;
    private volatile int referenceCounter;
    private volatile long lastPageId;

    MuninnPagedFile(File file, MuninnPageCache pageCache, int pageSize, PageSwapperFactory swapperFactory, MuninnCursorPool cursorPool, PageCacheMonitor monitor) throws IOException {
        this.pageCache = pageCache;
        this.pageSize = pageSize;
        this.cursorPool = cursorPool;
        this.monitor = monitor;
        this.translationTables = new PrimitiveLongObjectMap[translationTableStripeLevel];
        this.translationTableLocks = new StampedLock[translationTableStripeLevel];
        for (int i = 0; i < translationTableStripeLevel; ++i) {
            this.translationTables[i] = Primitive.longObjectMap((int)8);
            this.translationTableLocks[i] = new StampedLock();
        }
        MuninnPageEvictionCallback onEviction = new MuninnPageEvictionCallback(this.translationTables, this.translationTableLocks);
        this.swapper = swapperFactory.createPageSwapper(file, pageSize, onEviction);
        this.initialiseLastPageId(this.swapper.getLastPageId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.fileName() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags) {
        if (this.getRefCount() == 0) {
            throw new IllegalStateException("File has been unmapped");
        }
        int lockMask = 3;
        if ((pf_flags & lockMask) == 0) {
            throw new IllegalArgumentException("Must specify either PF_EXCLUSIVE_LOCK or PF_SHARED_LOCK");
        }
        if ((pf_flags & lockMask) == lockMask) {
            throw new IllegalArgumentException("Cannot specify both PF_EXCLUSIVE_LOCK and PF_SHARED_LOCK");
        }
        MuninnPageCursor cursor = (pf_flags & 1) == 0 ? this.cursorPool.takeWriteCursor() : this.cursorPool.takeReadCursor();
        cursor.initialise(this, pageId, pf_flags);
        cursor.rewind();
        return cursor;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this);
    }

    void closeSwapper() throws IOException {
        this.swapper.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        try (MajorFlushEvent flushEvent = this.monitor.beginFileFlush(this.swapper);){
            PageFlusher flusher = new PageFlusher(this.swapper, flushEvent);
            for (int i = 0; i < translationTableStripeLevel; ++i) {
                PrimitiveLongObjectMap<MuninnPage> translationTable = this.translationTables[i];
                StampedLock translationTableLock = this.translationTableLocks[i];
                long stamp = translationTableLock.readLock();
                try {
                    translationTable.visitEntries((PrimitiveLongObjectVisitor)flusher);
                    continue;
                }
                finally {
                    translationTableLock.unlockRead(stamp);
                }
            }
            this.force();
        }
    }

    @Override
    public void force() throws IOException {
        this.swapper.force();
    }

    @Override
    public long getLastPageId() {
        return this.lastPageId;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        UnsafeUtil.putLong(this, lastPageIdOffset, lastPageIdFromFile);
    }

    long increaseLastPageIdTo(long newLastPageId) {
        long current;
        while ((current = this.lastPageId) < newLastPageId && !UnsafeUtil.compareAndSwapLong(this, lastPageIdOffset, current, newLastPageId)) {
        }
        return this.lastPageId;
    }

    void incrementRefCount() {
        UnsafeUtil.getAndAddInt(this, referenceCounterOffset, 1);
    }

    boolean decrementRefCount() {
        return UnsafeUtil.getAndAddInt(this, referenceCounterOffset, -1) <= 1;
    }

    int getRefCount() {
        return UnsafeUtil.getIntVolatile(this, referenceCounterOffset);
    }

    MuninnPage grabFreePage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreePage(faultEvent);
    }
}

