/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.jsr166e.StampedLock;

final class MuninnPageEvictionCallback
implements PageEvictionCallback {
    private final PrimitiveLongObjectMap<MuninnPage>[] translationTables;
    private final StampedLock[] translationTableLocks;

    public MuninnPageEvictionCallback(PrimitiveLongObjectMap<MuninnPage>[] translationTables, StampedLock[] translationTableLocks) {
        this.translationTables = translationTables;
        this.translationTableLocks = translationTableLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvict(long pageId, Page page) {
        int stripe = (int)(pageId & (long)MuninnPagedFile.translationTableStripeMask);
        StampedLock translationTableLock = this.translationTableLocks[stripe];
        PrimitiveLongObjectMap<MuninnPage> translationTable = this.translationTables[stripe];
        long stamp = translationTableLock.tryWriteLock();
        if (stamp != 0L) {
            try {
                MuninnPage removed = (MuninnPage)translationTable.remove(pageId);
                assert (removed == page) : "Removed unexpected page when cleaning up translation table for filePageId " + pageId + ". Evicted " + page + " but removed " + removed + " from the " + "translation table.";
            }
            finally {
                translationTableLock.unlockWrite(stamp);
            }
        }
    }
}

