/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.monitoring.PageFaultEvent;
import org.neo4j.io.pagecache.monitoring.PinEvent;
import org.neo4j.jsr166e.StampedLock;

abstract class MuninnPageCursor
implements PageCursor {
    protected MuninnPagedFile pagedFile;
    protected MuninnPage page;
    protected PinEvent pinEvent;
    protected long pageId;
    protected int pf_flags;
    protected long currentPageId;
    protected long nextPageId;
    protected long lastPageId;
    protected long lockStamp;
    private boolean claimed;
    private int offset;

    MuninnPageCursor() {
    }

    public final void initialise(MuninnPagedFile pagedFile, long pageId, int pf_flags) {
        this.pagedFile = pagedFile;
        this.pageId = pageId;
        this.pf_flags = pf_flags;
    }

    public final void markAsClaimed() {
        this.claimed = true;
    }

    public final void assertUnclaimed() {
        if (this.claimed) {
            throw new IllegalStateException("Cannot operate on more than one PageCursor at a time, because it is prone to deadlocks");
        }
    }

    @Override
    public final void rewind() {
        this.nextPageId = this.pageId;
        this.currentPageId = -1L;
        this.lastPageId = this.pagedFile.getLastPageId();
    }

    public final void reset(MuninnPage page) {
        this.page = page;
        this.offset = 0;
        this.pinEvent.setCachePageId(page.getCachePageId());
    }

    @Override
    public final boolean next(long pageId) throws IOException {
        this.nextPageId = pageId;
        return this.next();
    }

    @Override
    public final void close() {
        this.unpinCurrentPage();
        this.pagedFile = null;
        this.claimed = false;
    }

    @Override
    public final long getCurrentPageId() {
        return this.currentPageId;
    }

    protected void pageFault(long filePageId, PrimitiveLongObjectMap<MuninnPage> translationTable, StampedLock translationTableLock, long ttlStamp, PageSwapper swapper) throws IOException {
        long stamp;
        MuninnPage page;
        PageFaultEvent faultEvent = this.pinEvent.beginPageFault();
        try {
            page = this.pagedFile.grabFreePage(faultEvent);
            stamp = page.writeLock();
            translationTable.put(filePageId, (Object)page);
        }
        catch (Throwable throwable) {
            faultEvent.done(throwable);
            throw throwable;
        }
        finally {
            translationTableLock.unlockWrite(ttlStamp);
        }
        try {
            this.assertPagedFileStillMapped();
            page.initBuffer();
            page.fault(swapper, filePageId, faultEvent);
        }
        catch (Throwable throwable) {
            page.unlockWrite(stamp);
            faultEvent.done(throwable);
            throw throwable;
        }
        this.convertPageFaultLock(page, stamp);
        this.pinCursorToPage(page, filePageId, swapper);
        faultEvent.done();
    }

    protected void assertPagedFileStillMapped() {
        if (this.pagedFile.getRefCount() == 0) {
            throw new IllegalStateException("File has been unmapped");
        }
    }

    protected abstract void unpinCurrentPage();

    protected abstract void convertPageFaultLock(MuninnPage var1, long var2);

    protected abstract void pinCursorToPage(MuninnPage var1, long var2, PageSwapper var4);

    @Override
    public final byte getByte() {
        byte b = this.page.getByte(this.offset);
        ++this.offset;
        return b;
    }

    @Override
    public byte getByte(int offset) {
        return this.page.getByte(offset);
    }

    @Override
    public void putByte(byte value) {
        this.page.putByte(value, this.offset);
        ++this.offset;
    }

    @Override
    public void putByte(int offset, byte value) {
        this.page.putByte(value, offset);
    }

    @Override
    public long getLong() {
        long l = this.page.getLong(this.offset);
        this.offset += 8;
        return l;
    }

    @Override
    public long getLong(int offset) {
        return this.page.getLong(offset);
    }

    @Override
    public void putLong(long value) {
        this.page.putLong(value, this.offset);
        this.offset += 8;
    }

    @Override
    public void putLong(int offset, long value) {
        this.page.putLong(value, offset);
    }

    @Override
    public int getInt() {
        int i = this.page.getInt(this.offset);
        this.offset += 4;
        return i;
    }

    @Override
    public int getInt(int offset) {
        return this.page.getInt(offset);
    }

    @Override
    public void putInt(int value) {
        this.page.putInt(value, this.offset);
        this.offset += 4;
    }

    @Override
    public void putInt(int offset, int value) {
        this.page.putInt(value, offset);
    }

    @Override
    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public long getUnsignedInt(int offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    @Override
    public void getBytes(byte[] data) {
        this.page.getBytes(data, this.offset);
        this.offset += data.length;
    }

    @Override
    public void putBytes(byte[] data) {
        this.page.putBytes(data, this.offset);
        this.offset += data.length;
    }

    @Override
    public final short getShort() {
        short s = this.page.getShort(this.offset);
        this.offset += 2;
        return s;
    }

    @Override
    public short getShort(int offset) {
        return this.page.getShort(offset);
    }

    @Override
    public void putShort(short value) {
        this.page.putShort(value, this.offset);
        this.offset += 2;
    }

    @Override
    public void putShort(int offset, short value) {
        this.page.putShort(value, offset);
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.offset = offset;
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }
}

