/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.RunnablePageCache;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.FileMapping;
import org.neo4j.io.pagecache.impl.muninn.FreePage;
import org.neo4j.io.pagecache.impl.muninn.FreePageWaiter;
import org.neo4j.io.pagecache.impl.muninn.MemoryReleaser;
import org.neo4j.io.pagecache.impl.muninn.MuninnCursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile;
import org.neo4j.io.pagecache.impl.muninn.UnsafeUtil;
import org.neo4j.io.pagecache.monitoring.EvictionEvent;
import org.neo4j.io.pagecache.monitoring.EvictionRunEvent;
import org.neo4j.io.pagecache.monitoring.MajorFlushEvent;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.io.pagecache.monitoring.PageFaultEvent;

public class MuninnPageCache
implements RunnablePageCache {
    private static final int pageFaultSpinCount = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.pageFaultSpinCount", FileUtils.OS_IS_WINDOWS ? 10 : 1000);
    private static final int pagesToKeepFree = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.pagesToKeepFree", 30);
    private static final IOException oomException = new IOException("OutOfMemoryError encountered in the page cache background eviction thread");
    private static final long freelistOffset = UnsafeUtil.getFieldOffset(MuninnPageCache.class, "freelist");
    private static final FreePageWaiter shutdownSignal = new FreePageWaiter();
    private final PageSwapperFactory swapperFactory;
    private final int cachePageSize;
    private final int keepFree;
    private final MuninnCursorPool cursorPool;
    private final PageCacheMonitor monitor;
    final MuninnPage[] pages;
    private volatile Object freelist;
    private volatile FileMapping mappedFiles;
    private volatile Thread evictorThread;
    private volatile IOException evictorException;
    private volatile boolean closed;

    public MuninnPageCache(FileSystemAbstraction fs, int maxPages, int pageSize, PageCacheMonitor monitor) {
        this(new SingleFilePageSwapperFactory(fs), maxPages, pageSize, monitor);
    }

    public MuninnPageCache(PageSwapperFactory swapperFactory, int maxPages, int cachePageSize, PageCacheMonitor monitor) {
        MuninnPageCache.verifyHacks();
        MuninnPageCache.verifyCachePageSizeIsPowerOfTwo(cachePageSize);
        this.swapperFactory = swapperFactory;
        this.cachePageSize = cachePageSize;
        this.keepFree = Math.min(pagesToKeepFree, maxPages / 2);
        this.cursorPool = new MuninnCursorPool();
        this.monitor = monitor;
        this.pages = new MuninnPage[maxPages];
        MemoryReleaser memoryReleaser = new MemoryReleaser(maxPages);
        Object pageList = null;
        int pageIndex = maxPages;
        while (pageIndex-- > 0) {
            FreePage freePage;
            MuninnPage page;
            this.pages[pageIndex] = page = new MuninnPage(cachePageSize, memoryReleaser);
            if (pageList == null) {
                freePage = new FreePage(page);
                freePage.setNext(null);
                pageList = freePage;
                continue;
            }
            if (pageList instanceof FreePage && ((FreePage)pageList).count < this.keepFree) {
                freePage = new FreePage(page);
                freePage.setNext((FreePage)pageList);
                pageList = freePage;
                continue;
            }
            page.nextFree = pageList;
            pageList = page;
        }
        UnsafeUtil.putObjectVolatile(this, freelistOffset, pageList);
    }

    private static void verifyHacks() {
        if (!UnsafeUtil.hasUnsafe()) {
            throw new AssertionError((Object)"MuninnPageCache requires access to sun.misc.Unsafe");
        }
    }

    private static void verifyCachePageSizeIsPowerOfTwo(int cachePageSize) {
        int exponent = 31 - Integer.numberOfLeadingZeros(cachePageSize);
        if (1 << exponent != cachePageSize) {
            throw new IllegalArgumentException("Cache page size must be a power of two, but was " + cachePageSize);
        }
    }

    @Override
    public synchronized PagedFile map(File file, int filePageSize) throws IOException {
        this.assertHealthy();
        if (filePageSize > this.cachePageSize) {
            throw new IllegalArgumentException("Cannot map files with a filePageSize (" + filePageSize + ") that is greater than the cachePageSize (" + this.cachePageSize + ")");
        }
        FileMapping current = this.mappedFiles;
        while (current != null) {
            if (current.file.equals(file)) {
                MuninnPagedFile pagedFile = current.pagedFile;
                if (pagedFile.pageSize() != filePageSize) {
                    String msg = "Cannot map file " + file + " with " + "filePageSize " + filePageSize + " bytes, " + "because it has already been mapped with a " + "filePageSize of " + pagedFile.pageSize() + " bytes.";
                    throw new IllegalArgumentException(msg);
                }
                pagedFile.incrementRefCount();
                return pagedFile;
            }
            current = current.next;
        }
        MuninnPagedFile pagedFile = new MuninnPagedFile(file, this, filePageSize, this.swapperFactory, this.cursorPool, this.monitor);
        pagedFile.incrementRefCount();
        current = new FileMapping(file, pagedFile);
        current.next = this.mappedFiles;
        this.mappedFiles = current;
        this.monitor.mappedFile(file);
        return pagedFile;
    }

    synchronized void unmap(MuninnPagedFile file) {
        if (file.decrementRefCount()) {
            FileMapping prev = null;
            FileMapping current = this.mappedFiles;
            while (current != null) {
                if (current.pagedFile == file) {
                    if (prev == null) {
                        this.mappedFiles = current.next;
                    } else {
                        prev.next = current.next;
                    }
                    this.monitor.unmappedFile(current.file);
                    this.flushAndCloseWithoutFail(file);
                    break;
                }
                prev = current;
                current = current.next;
            }
        }
    }

    private void flushAndCloseWithoutFail(MuninnPagedFile file) {
        boolean flushedAndClosed = false;
        boolean printedFirstException = false;
        do {
            try {
                file.flush();
                file.closeSwapper();
                flushedAndClosed = true;
            }
            catch (IOException e) {
                if (printedFirstException) continue;
                printedFirstException = true;
                try {
                    e.printStackTrace();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
        } while (!flushedAndClosed);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.assertNotClosed();
        this.flushAllPages();
        this.clearEvictorException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushAllPages() throws IOException {
        try (MajorFlushEvent cacheFlush = this.monitor.beginCacheFlush();){
            for (int i = 0; i < this.pages.length; ++i) {
                MuninnPage page = this.pages[i];
                long stamp = page.readLock();
                try {
                    page.flush(cacheFlush.flushEventOpportunity());
                    continue;
                }
                finally {
                    page.unlockRead(stamp);
                }
            }
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        FileMapping files = this.mappedFiles;
        if (files != null) {
            StringBuilder msg = new StringBuilder("Cannot close the PageCache while files are still mapped:");
            while (files != null) {
                int refCount = files.pagedFile.getRefCount();
                msg.append("\n\t");
                msg.append(files.file.getName());
                msg.append(" (").append(refCount);
                msg.append(refCount == 1 ? " mapping)" : " mappings)");
                files = files.next;
            }
            throw new IllegalStateException(msg.toString());
        }
        this.closed = true;
        for (int i = 0; i < this.pages.length; ++i) {
            this.pages[i] = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void assertHealthy() throws IOException {
        this.assertNotClosed();
        IOException exception = this.evictorException;
        if (exception != null) {
            throw new IOException("Exception in the page eviction thread", exception);
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("The PageCache has been shut down");
        }
    }

    @Override
    public int pageSize() {
        return this.cachePageSize;
    }

    @Override
    public int maxCachedPages() {
        return this.pages.length;
    }

    MuninnPage grabFreePage(PageFaultEvent faultEvent) throws IOException {
        FreePageWaiter waiter = null;
        int iterationCount = 0;
        boolean shouldUnparkInSpin = true;
        while (true) {
            this.assertHealthy();
            Object current = this.getFreelistHead();
            if (current == null && ++iterationCount > pageFaultSpinCount) {
                waiter = waiter == null ? new FreePageWaiter() : waiter;
                waiter.next = null;
                if (this.compareAndSetFreelistHead(null, waiter)) {
                    this.unparkEvictor();
                    faultEvent.setParked(true);
                    return waiter.park(this);
                }
            } else {
                if (current == null) {
                    if (!shouldUnparkInSpin) continue;
                    this.unparkEvictor();
                    shouldUnparkInSpin = false;
                    continue;
                }
                if (current instanceof MuninnPage) {
                    MuninnPage page = (MuninnPage)current;
                    if (this.compareAndSetFreelistHead(page, page.nextFree)) {
                        return page;
                    }
                } else if (current instanceof FreePage) {
                    FreePage freePage = (FreePage)current;
                    if (this.compareAndSetFreelistHead(freePage, freePage.next)) {
                        return freePage.page;
                    }
                } else if (current instanceof FreePageWaiter) {
                    if (current == shutdownSignal) {
                        throw new IllegalStateException("The PageCache has been shut down");
                    }
                    waiter = waiter == null ? new FreePageWaiter() : waiter;
                    waiter.next = (FreePageWaiter)current;
                    if (this.compareAndSetFreelistHead(current, waiter)) {
                        this.unparkEvictor();
                        faultEvent.setParked(true);
                        return waiter.park(this);
                    }
                }
            }
            this.unparkEvictor();
        }
    }

    private void unparkEvictor() {
        LockSupport.unpark(this.evictorThread);
    }

    private Object getFreelistHead() {
        return UnsafeUtil.getObjectVolatile(this, freelistOffset);
    }

    private boolean compareAndSetFreelistHead(Object expected, Object update) {
        return UnsafeUtil.compareAndSwapObject(this, freelistOffset, expected, update);
    }

    private Object getAndSetFreelistHead(Object newFreelistHead) {
        return UnsafeUtil.getAndSetObject(this, freelistOffset, newFreelistHead);
    }

    @Override
    public void run() {
        this.evictorThread = Thread.currentThread();
        this.continuouslySweepPages();
    }

    private void continuouslySweepPages() {
        int clockArm = 0;
        while (!Thread.interrupted()) {
            int pageCountToEvict = this.parkUntilEvictionRequired(this.keepFree);
            EvictionRunEvent evictionRunEvent = this.monitor.beginPageEvictions(pageCountToEvict);
            Throwable throwable = null;
            try {
                clockArm = this.evictPages(pageCountToEvict, clockArm, evictionRunEvent);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (evictionRunEvent == null) continue;
                if (throwable != null) {
                    try {
                        evictionRunEvent.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                evictionRunEvent.close();
            }
        }
        Object freelistHead = this.getAndSetFreelistHead(shutdownSignal);
        if (freelistHead instanceof FreePageWaiter) {
            FreePageWaiter waiters = (FreePageWaiter)freelistHead;
            this.interruptAllWaiters(waiters);
        }
    }

    private void interruptAllWaiters(FreePageWaiter waiters) {
        while (waiters != null) {
            waiters.unparkInterrupt();
            waiters = waiters.next;
        }
    }

    private int parkUntilEvictionRequired(int keepFree) {
        long parkNanos = TimeUnit.MILLISECONDS.toNanos(10L);
        while (true) {
            LockSupport.parkNanos(parkNanos);
            if (Thread.currentThread().isInterrupted() || this.closed) {
                return 0;
            }
            Object freelistHead = this.getFreelistHead();
            if (freelistHead instanceof FreePage) {
                int availablePages = ((FreePage)freelistHead).count;
                if (availablePages >= keepFree) continue;
                return keepFree - availablePages;
            }
            if (freelistHead instanceof FreePageWaiter) break;
        }
        return keepFree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int evictPages(int pageCountToEvict, int clockArm, EvictionRunEvent evictionRunEvent) {
        FreePageWaiter waiters = this.grabFreePageWaitersIfAny();
        Thread currentThread = Thread.currentThread();
        while (!(pageCountToEvict <= 0 && waiters == null || currentThread.isInterrupted())) {
            long stamp;
            MuninnPage page;
            if (clockArm == this.pages.length) {
                clockArm = 0;
            }
            if ((page = this.pages[clockArm]) == null) {
                currentThread.interrupt();
                this.interruptAllWaiters(waiters);
                return 0;
            }
            if (page.isLoaded() && page.decrementUsage() && (stamp = page.tryWriteLock()) != 0L) {
                boolean pageEvicted;
                --pageCountToEvict;
                try (EvictionEvent evictionEvent = evictionRunEvent.beginEviction();){
                    pageEvicted = this.evictPage(page, evictionEvent);
                }
                finally {
                    page.unlockWrite(stamp);
                }
                if (pageEvicted) {
                    if (waiters != null) {
                        waiters.unpark(page);
                        waiters = waiters.next;
                    } else {
                        FreePageWaiter waiter;
                        Object nextListHead;
                        Object current;
                        FreePage freePage = null;
                        do {
                            waiter = null;
                            current = this.getFreelistHead();
                            if (current == null || current instanceof FreePage) {
                                freePage = freePage == null ? new FreePage(page) : freePage;
                                freePage.setNext((FreePage)current);
                                nextListHead = freePage;
                                continue;
                            }
                            assert (current instanceof FreePageWaiter) : "Unexpected link type: " + current;
                            waiter = (FreePageWaiter)current;
                            nextListHead = waiter.next;
                        } while (!this.compareAndSetFreelistHead(current, nextListHead));
                        if (waiter != null) {
                            waiter.unpark(page);
                        }
                    }
                } else if (waiters != null && this.evictorException != null) {
                    waiters.unparkException(this.evictorException);
                    waiters = waiters.next;
                }
            }
            ++clockArm;
        }
        this.interruptAllWaiters(waiters);
        return clockArm;
    }

    private boolean evictPage(MuninnPage page, EvictionEvent evictionEvent) {
        try {
            page.evict(evictionEvent);
            this.clearEvictorException();
            return true;
        }
        catch (IOException ioException) {
            this.evictorException = ioException;
            evictionEvent.threwException(ioException);
        }
        catch (OutOfMemoryError ignore) {
            this.evictorException = oomException;
            evictionEvent.threwException(oomException);
        }
        catch (Throwable throwable) {
            this.evictorException = new IOException("Eviction thread encountered a problem", throwable);
            evictionEvent.threwException(this.evictorException);
        }
        return false;
    }

    private FreePageWaiter grabFreePageWaitersIfAny() {
        Object freelistHead = this.getFreelistHead();
        if (freelistHead instanceof FreePageWaiter) {
            FreePageWaiter waiters = (FreePageWaiter)this.getAndSetFreelistHead(null);
            return this.reverse(waiters);
        }
        return null;
    }

    private FreePageWaiter reverse(FreePageWaiter waiters) {
        FreePageWaiter result = null;
        while (waiters != null) {
            FreePageWaiter tail = waiters.next;
            waiters.next = result;
            result = waiters;
            waiters = tail;
        }
        return result;
    }

    private void clearEvictorException() {
        this.evictorException = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MuninnPageCache[ \n");
        for (MuninnPage page : this.pages) {
            sb.append(' ').append(page).append('\n');
        }
        sb.append(']').append('\n');
        return sb.toString();
    }
}

