/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.MemoryReleaser;
import org.neo4j.io.pagecache.impl.muninn.UnsafeUtil;
import org.neo4j.io.pagecache.monitoring.EvictionEvent;
import org.neo4j.io.pagecache.monitoring.FlushEvent;
import org.neo4j.io.pagecache.monitoring.FlushEventOpportunity;
import org.neo4j.io.pagecache.monitoring.PageFaultEvent;
import org.neo4j.jsr166e.StampedLock;

final class MuninnPage
extends StampedLock
implements Page {
    private static final long usageStampOffset = UnsafeUtil.getFieldOffset(MuninnPage.class, "usageStamp");
    private byte cachePageHeader;
    private final MemoryReleaser memoryReleaser;
    private long pointer;
    private volatile byte usageStamp;
    public Object nextFree;
    private PageSwapper swapper;
    private long filePageId = -1L;

    public MuninnPage(int cachePageSize, MemoryReleaser memoryReleaser) {
        this.cachePageHeader = (byte)(31 - Integer.numberOfLeadingZeros(cachePageSize));
        this.memoryReleaser = memoryReleaser;
        this.getCachePageId();
    }

    private void checkBounds(int position) {
        if (position > this.getCachePageSize()) {
            String msg = "Position " + position + " is greater than the upper " + "page size bound of " + this.getCachePageSize();
            throw new IndexOutOfBoundsException(msg);
        }
    }

    @Override
    public int getCachePageId() {
        return System.identityHashCode(this);
    }

    private int getCachePageSize() {
        return 1 << (this.cachePageHeader & 0x7F);
    }

    private boolean isDirty() {
        return (this.cachePageHeader & 0xFFFFFF80) != 0;
    }

    public void markAsDirty() {
        this.cachePageHeader = (byte)(this.cachePageHeader | 0xFFFFFF80);
    }

    private void markAsClean() {
        this.cachePageHeader = (byte)(this.cachePageHeader & 0x7F);
    }

    @Override
    public byte getByte(int offset) {
        this.checkBounds(offset + 1);
        return UnsafeUtil.getByte(this.pointer + (long)offset);
    }

    @Override
    public void putByte(byte value, int offset) {
        this.checkBounds(offset + 1);
        UnsafeUtil.putByte(this.pointer + (long)offset, value);
    }

    @Override
    public long getLong(int offset) {
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long x = UnsafeUtil.getLong(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Long.reverseBytes(x);
        }
        return this.getLongBigEndian(offset);
    }

    private long getLongBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        long a = UnsafeUtil.getByte(p) & 0xFF;
        long b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        long c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        long d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        long e = UnsafeUtil.getByte(p + 4L) & 0xFF;
        long f = UnsafeUtil.getByte(p + 5L) & 0xFF;
        long g = UnsafeUtil.getByte(p + 6L) & 0xFF;
        long h = UnsafeUtil.getByte(p + 7L) & 0xFF;
        return a << 56 | b << 48 | c << 40 | d << 32 | e << 24 | f << 16 | g << 8 | h;
    }

    @Override
    public void putLong(long value, int offset) {
        this.checkBounds(offset + 8);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putLong(p, UnsafeUtil.storeByteOrderIsNative ? value : Long.reverseBytes(value));
        } else {
            this.putLongBigEndian(value, offset);
        }
    }

    private void putLongBigEndian(long value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 56));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 48));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 40));
        UnsafeUtil.putByte(p + 3L, (byte)(value >> 32));
        UnsafeUtil.putByte(p + 4L, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 5L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 6L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 7L, (byte)value);
    }

    @Override
    public int getInt(int offset) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            int x = UnsafeUtil.getInt(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Integer.reverseBytes(x);
        }
        return this.getIntBigEndian(offset);
    }

    private int getIntBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        int a = UnsafeUtil.getByte(p) & 0xFF;
        int b = UnsafeUtil.getByte(p + 1L) & 0xFF;
        int c = UnsafeUtil.getByte(p + 2L) & 0xFF;
        int d = UnsafeUtil.getByte(p + 3L) & 0xFF;
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Override
    public void putInt(int value, int offset) {
        this.checkBounds(offset + 4);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putInt(p, UnsafeUtil.storeByteOrderIsNative ? value : Integer.reverseBytes(value));
        } else {
            this.putIntBigEndian(value, offset);
        }
    }

    private void putIntBigEndian(int value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 24));
        UnsafeUtil.putByte(p + 1L, (byte)(value >> 16));
        UnsafeUtil.putByte(p + 2L, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 3L, (byte)value);
    }

    @Override
    public short getShort(int offset) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            short x = UnsafeUtil.getShort(this.pointer + (long)offset);
            return UnsafeUtil.storeByteOrderIsNative ? x : Short.reverseBytes(x);
        }
        return this.getShortBigEndian(offset);
    }

    private short getShortBigEndian(int offset) {
        long p = this.pointer + (long)offset;
        short a = (short)(UnsafeUtil.getByte(p) & 0xFF);
        short b = (short)(UnsafeUtil.getByte(p + 1L) & 0xFF);
        return (short)(a << 8 | b);
    }

    @Override
    public void putShort(short value, int offset) {
        this.checkBounds(offset + 2);
        if (UnsafeUtil.allowUnalignedMemoryAccess) {
            long p = this.pointer + (long)offset;
            UnsafeUtil.putShort(p, UnsafeUtil.storeByteOrderIsNative ? value : Short.reverseBytes(value));
        } else {
            this.putShortBigEndian(value, offset);
        }
    }

    private void putShortBigEndian(short value, int offset) {
        long p = this.pointer + (long)offset;
        UnsafeUtil.putByte(p, (byte)(value >> 8));
        UnsafeUtil.putByte(p + 1L, (byte)value);
    }

    @Override
    public void getBytes(byte[] data, int offset) {
        this.checkBounds(offset + data.length);
        long address = this.pointer + (long)offset;
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            data[i] = UnsafeUtil.getByte(address);
            ++address;
        }
    }

    @Override
    public void putBytes(byte[] data, int offset) {
        this.checkBounds(offset + data.length);
        long address = this.pointer + (long)offset;
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            UnsafeUtil.putByte(address, data[i]);
            ++address;
        }
    }

    public void incrementUsage() {
        byte usage = UnsafeUtil.getByteVolatile(this, usageStampOffset);
        usage = (byte)(usage << 1);
        usage = (byte)(usage + 1);
        usage = (byte)(usage & 0xF);
        UnsafeUtil.putByteVolatile(this, usageStampOffset, usage);
    }

    public boolean decrementUsage() {
        byte usage = UnsafeUtil.getByteVolatile(this, usageStampOffset);
        usage = (byte)(usage >>> 1);
        UnsafeUtil.putByteVolatile(this, usageStampOffset, usage);
        return usage == 0;
    }

    @Override
    public int swapIn(StoreChannel channel, long offset, int length) throws IOException {
        assert (this.isWriteLocked()) : "swapIn requires write lock to protect the cache page";
        int readTotal = 0;
        try {
            int read;
            ByteBuffer bufferProxy = UnsafeUtil.newDirectByteBuffer(this.pointer, this.getCachePageSize());
            bufferProxy.clear();
            bufferProxy.limit(length);
            while ((read = channel.read(bufferProxy, offset + (long)readTotal)) != -1 && (readTotal += read) < length) {
            }
            while (bufferProxy.position() < bufferProxy.limit()) {
                bufferProxy.put((byte)0);
            }
            return readTotal;
        }
        catch (ClosedChannelException e) {
            throw e;
        }
        catch (Throwable e) {
            String msg = String.format("Read failed after %s of %s bytes from offset %s", readTotal, length, offset);
            throw new IOException(msg, e);
        }
    }

    @Override
    public void swapOut(StoreChannel channel, long offset, int length) throws IOException {
        assert (this.isReadLocked() || this.isWriteLocked()) : "swapOut requires lock";
        try {
            ByteBuffer bufferProxy = UnsafeUtil.newDirectByteBuffer(this.pointer, this.getCachePageSize());
            bufferProxy.clear();
            bufferProxy.limit(length);
            channel.writeAll(bufferProxy, offset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void flush(FlushEventOpportunity flushOpportunity) throws IOException {
        if (this.swapper != null && this.isDirty()) {
            this.doFlush(this.swapper, this.filePageId, flushOpportunity);
        }
    }

    public void flush(PageSwapper swapper, long filePageId, FlushEventOpportunity flushOpportunity) throws IOException {
        if (this.isDirty() && this.swapper == swapper && this.filePageId == filePageId) {
            this.doFlush(swapper, filePageId, flushOpportunity);
        }
    }

    private void doFlush(PageSwapper swapper, long filePageId, FlushEventOpportunity flushOpportunity) throws IOException {
        FlushEvent event = flushOpportunity.beginFlush(filePageId, this.getCachePageId(), swapper);
        try {
            int bytesWritten = swapper.write(filePageId, this);
            this.markAsClean();
            event.addBytesWritten(bytesWritten);
            event.done();
        }
        catch (IOException e) {
            event.done(e);
            throw e;
        }
    }

    public void fault(PageSwapper swapper, long filePageId, PageFaultEvent faultEvent) throws IOException {
        assert (this.isWriteLocked()) : "Cannot fault page without write-lock";
        if (this.swapper != null || this.filePageId != -1L) {
            String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s} into cache page %s. Already bound to {filePageId = %s, swapper = %s}.", filePageId, swapper, this.getCachePageId(), this.filePageId, this.swapper);
            throw new IllegalStateException(msg);
        }
        this.filePageId = filePageId;
        int bytesRead = swapper.read(filePageId, this);
        faultEvent.addBytesRead(bytesRead);
        faultEvent.setCachePageId(this.getCachePageId());
        this.swapper = swapper;
    }

    public void evict(EvictionEvent evictionEvent) throws IOException {
        assert (this.isWriteLocked()) : "Cannot evict page without write-lock";
        long filePageId = this.filePageId;
        evictionEvent.setCachePageId(this.getCachePageId());
        evictionEvent.setFilePageId(filePageId);
        this.flush(evictionEvent.flushEventOpportunity());
        UnsafeUtil.setMemory(this.pointer, this.getCachePageSize(), (byte)0);
        this.filePageId = -1L;
        PageSwapper swapper = this.swapper;
        this.swapper = null;
        if (swapper != null) {
            swapper.evicted(filePageId, this);
            evictionEvent.setSwapper(swapper);
        }
    }

    public boolean isLoaded() {
        return this.filePageId != -1L;
    }

    public boolean isBoundTo(PageSwapper swapper, long filePageId) {
        return this.swapper == swapper && this.filePageId == filePageId;
    }

    public void initBuffer() {
        assert (this.isWriteLocked()) : "Cannot initBuffer without write-lock";
        if (this.pointer == 0L) {
            this.pointer = UnsafeUtil.malloc(this.getCachePageSize());
            this.memoryReleaser.registerPointer(this.pointer);
        }
    }

    public PageSwapper getSwapper() {
        return this.swapper;
    }

    public long getFilePageId() {
        return this.filePageId;
    }

    public String toString() {
        return String.format("MuninnPage@%x[%s -> %x, filePageId = %s%s, swapper = %s]%s", this.hashCode(), this.getCachePageId(), this.pointer, this.filePageId, this.isDirty() ? ", dirty" : "", this.swapper, this.getLockStateString());
    }
}

