/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.Page;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.UnsafeUtil;

public class SingleFilePageSwapper
implements PageSwapper {
    private static final long fileSizeOffset = UnsafeUtil.getFieldOffset(SingleFilePageSwapper.class, "fileSize");
    private final FileSystemAbstraction fs;
    private final File file;
    private final int filePageSize;
    private PageEvictionCallback onEviction;
    private volatile StoreChannel channel;
    private boolean closed;
    private volatile long fileSize;

    public SingleFilePageSwapper(File file, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction) throws IOException {
        this.fs = fs;
        this.file = file;
        this.channel = fs.open(file, "rw");
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channel.size());
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !UnsafeUtil.compareAndSwapLong(this, fileSizeOffset, currentFileSize, newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return UnsafeUtil.getLongVolatile(this, fileSizeOffset);
    }

    @Override
    public int read(long filePageId, Page page) throws IOException {
        long offset = this.pageIdToPosition(filePageId);
        try {
            if (offset < this.getCurrentFileSize()) {
                return page.swapIn(this.channel, offset, this.filePageSize);
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(e);
            boolean interrupted = Thread.interrupted();
            int bytesRead = this.read(filePageId, page);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesRead;
        }
        return 0;
    }

    @Override
    public int write(long filePageId, Page page) throws IOException {
        long offset = this.pageIdToPosition(filePageId);
        this.increaseFileSizeTo(offset + (long)this.filePageSize);
        try {
            page.swapOut(this.channel, offset, this.filePageSize);
            return this.filePageSize;
        }
        catch (ClosedChannelException e) {
            this.tryReopen(e);
            boolean interrupted = Thread.interrupted();
            int bytesWritten = this.write(filePageId, page);
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
            return bytesWritten;
        }
    }

    @Override
    public void evicted(long filePageId, Page page) {
        if (this.onEviction != null) {
            this.onEviction.onEvict(filePageId, page);
        }
    }

    @Override
    public String fileName() {
        return this.file.getName();
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return !(this.channel == null ? that.channel != null : !this.channel.equals(that.channel));
    }

    public int hashCode() {
        return this.channel != null ? this.channel.hashCode() : 0;
    }

    private synchronized void tryReopen(ClosedChannelException closedException) throws ClosedChannelException {
        if (this.channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channel = this.fs.open(this.file, "rw");
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.channel.close();
        this.onEviction = null;
    }

    @Override
    public void force() throws IOException {
        this.channel.force(false);
    }

    @Override
    public long getLastPageId() throws IOException {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div - 1L : div;
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.file + '}';
    }
}

