/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import org.eclipse.collections.api.block.function.primitive.LongToLongFunction;

class LongSpinLatch {
    private static final long MAX_SPIN_NANOS = TimeUnit.MICROSECONDS.toNanos(500L);
    private static final long PARK_NANOS = TimeUnit.MICROSECONDS.toNanos(100L);
    private static final long TEST_FAILED = -1L;
    private static final long DEAD = -2L;
    static final int WRITE_LATCH_DEAD = -1;
    static final int WRITE_LATCH_ACQUIRED = 1;
    static final int WRITE_LATCH_NOT_ACQUIRED = 0;
    private static final long WRITE_LOCK_MASK = 32768L;
    private static final long READ_LOCK_MASK = 32767L;
    private static final long LOCK_MASK = 65535L;
    private static final long TREE_NODE_ID_MASK = -65536L;
    private static final int TREE_NODE_ID_SHIFT = 16;
    private static final LongPredicate ALWAYS_TRUE = bits -> true;
    private static final LongPredicate NO_LOCK = bits -> (bits & 0xFFFFL) == 0L;
    private static final LongPredicate NO_WRITE_LOCK = bits -> (bits & 0x8000L) == 0L;
    private static final LongPredicate NO_WRITE_ONLY_MY_READ_LOCK = bits -> (bits & 0xFFFFL) == 1L;
    private static final LongPredicate NO_READ_LOCK = bits -> (bits & 0x7FFFL) == 0L;
    private static final LongToLongFunction ACQUIRE_READ_LOCK = (LongToLongFunction & Serializable)bits -> bits + 1L;
    private static final LongToLongFunction RELEASE_READ_LOCK = (LongToLongFunction & Serializable)bits -> LongSpinLatch.markAsDeadIfNoLocksLeft(bits - 1L);
    private static final LongToLongFunction ACQUIRE_WRITE_LOCK = (LongToLongFunction & Serializable)bits -> bits | 0x8000L;
    private static final LongToLongFunction ACQUIRE_WRITE_LOCK_CLEAR_READ_LOCKS = (LongToLongFunction & Serializable)bits -> bits & 0xFFFFFFFFFFFF0000L | 0x8000L;
    private static final LongToLongFunction RELEASE_WRITE_LOCK = (LongToLongFunction & Serializable)bits -> LongSpinLatch.markAsDeadIfNoLocksLeft(bits & 0xFFFFFFFFFFFF7FFFL);
    private static final LongToLongFunction NO_TRANSFORM = (LongToLongFunction & Serializable)bits -> bits;
    private final long initialTreeNodeId;
    private final LongConsumer removeAction;
    private volatile long lockBits;
    private static final VarHandle LOCK_BITS;

    LongSpinLatch(long treeNodeId, LongConsumer removeAction) {
        assert (treeNodeId > 0L);
        this.lockBits = treeNodeId << 16;
        this.initialTreeNodeId = treeNodeId;
        this.removeAction = removeAction;
    }

    int acquireRead() {
        long transformed = this.spinTransform(NO_WRITE_LOCK, ACQUIRE_READ_LOCK, false);
        if (transformed == -2L) {
            return 0;
        }
        return Math.toIntExact(transformed & 0x7FFFL);
    }

    int releaseRead() {
        long transformed = this.spinTransform(ALWAYS_TRUE, RELEASE_READ_LOCK, false);
        this.checkRemove(transformed);
        return Math.toIntExact(transformed & 0x7FFFL);
    }

    private void checkRemove(long transformed) {
        if (transformed == 0L) {
            this.removeAction.accept(this.initialTreeNodeId);
        }
    }

    boolean tryUpgradeToWrite() {
        return this.spinTransform(NO_WRITE_ONLY_MY_READ_LOCK, ACQUIRE_WRITE_LOCK_CLEAR_READ_LOCKS, true) != -1L;
    }

    boolean acquireWrite() {
        long writeLockResult = this.spinTransform(NO_WRITE_LOCK, ACQUIRE_WRITE_LOCK, false);
        if (writeLockResult == -2L) {
            return false;
        }
        this.spinTransform(NO_READ_LOCK, NO_TRANSFORM, false);
        return true;
    }

    int tryAcquireWrite() {
        long writeLockResult = this.spinTransform(NO_WRITE_LOCK, ACQUIRE_WRITE_LOCK, true);
        if (writeLockResult == -2L) {
            return -1;
        }
        if (writeLockResult == -1L) {
            return 0;
        }
        return 1;
    }

    void releaseWrite() {
        long transformed = this.spinTransform(ALWAYS_TRUE, RELEASE_WRITE_LOCK, false);
        this.checkRemove(transformed);
    }

    long treeNodeId() {
        return LongSpinLatch.treeNodeIdFromBits(this.volatileGetBits());
    }

    private long spinTransform(LongPredicate tester, LongToLongFunction transformer, boolean breakOnTestFail) {
        long transformedBits;
        long timedWaitStartTime = 0L;
        while (true) {
            long bits;
            long l;
            if ((l = LongSpinLatch.treeNodeIdFromBits(bits = this.volatileGetBits())) != this.initialTreeNodeId) {
                return -2L;
            }
            if (!tester.test(bits)) {
                if (breakOnTestFail) {
                    return -1L;
                }
                if (timedWaitStartTime == 0L) {
                    timedWaitStartTime = System.nanoTime() + MAX_SPIN_NANOS;
                } else if (System.nanoTime() > timedWaitStartTime) {
                    LockSupport.parkNanos(PARK_NANOS);
                }
                Thread.onSpinWait();
                continue;
            }
            transformedBits = transformer.applyAsLong(bits);
            if (LOCK_BITS.compareAndSet(this, bits, transformedBits)) break;
        }
        return transformedBits;
    }

    private static long treeNodeIdFromBits(long bits) {
        return (bits & 0xFFFFFFFFFFFF0000L) >>> 16;
    }

    private static long markAsDeadIfNoLocksLeft(long result) {
        return (result & 0xFFFFL) == 0L ? 0L : result;
    }

    private long volatileGetBits() {
        return LOCK_BITS.getVolatile(this);
    }

    public String toString() {
        long bits = this.volatileGetBits();
        return String.format("Lock[%d,w:%b,r:%d]", LongSpinLatch.treeNodeIdFromBits(bits), (bits & 0x8000L) != 0L, bits & 0x7FFFL);
    }

    static {
        try {
            LOCK_BITS = MethodHandles.lookup().findVarHandle(LongSpinLatch.class, "lockBits", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

