/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.neo4j.index.internal.gbptree.CursorCreator;
import org.neo4j.index.internal.gbptree.FreeListIdProvider;
import org.neo4j.index.internal.gbptree.Generation;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.InternalTreeLogic;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.PointerChecking;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.StructurePropagation;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeRootExchange;
import org.neo4j.index.internal.gbptree.TreeWriterCoordination;
import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.index.internal.gbptree.ValueMergers;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageCursorUtil;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;

class GBPTreeWriter<K, V>
implements Writer<K, V> {
    private final InternalTreeLogic<K, V> treeLogic;
    private final ReadWriteLock checkpointLock;
    private final ReadWriteLock writerLock;
    private final FreeListIdProvider freeList;
    private final MultiRootGBPTree.Monitor monitor;
    private final Consumer<Throwable> exceptionMessageAppender;
    private final LongSupplier generationSupplier;
    private final StructurePropagation<K> structurePropagation;
    private final PagedFile pagedFile;
    private final TreeWriterCoordination coordination;
    private final TreeNode<K, V> bTreeNode;
    private final boolean parallel;
    private final TreeRootExchange rootExchange;
    private final Layout<K, V> layout;
    private boolean writerLockAcquired;
    private PageCursor cursor;
    private CursorContext cursorContext;
    private double ratioToKeepInLeftOnSplit;
    private Root root;
    private long stableGeneration;
    private long unstableGeneration;

    GBPTreeWriter(Layout<K, V> layout, PagedFile pagedFile, TreeWriterCoordination coordination, InternalTreeLogic<K, V> treeLogic, TreeNode<K, V> bTreeNode, boolean parallel, TreeRootExchange rootExchange, ReadWriteLock checkpointLock, ReadWriteLock writerLock, FreeListIdProvider freeList, MultiRootGBPTree.Monitor monitor, Consumer<Throwable> exceptionMessageAppender, LongSupplier generationSupplier) {
        this.layout = layout;
        this.pagedFile = pagedFile;
        this.coordination = coordination;
        this.bTreeNode = bTreeNode;
        this.parallel = parallel;
        this.rootExchange = rootExchange;
        this.structurePropagation = new StructurePropagation(layout.newKey(), layout.newKey(), layout.newKey());
        this.treeLogic = treeLogic;
        this.checkpointLock = checkpointLock;
        this.writerLock = writerLock;
        this.freeList = freeList;
        this.monitor = monitor;
        this.exceptionMessageAppender = exceptionMessageAppender;
        this.generationSupplier = generationSupplier;
    }

    void initialize(double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        if (this.writerLockAcquired) {
            throw this.appendTreeInformation(new IllegalStateException(String.format("This writer has already been initialized %s", this)));
        }
        this.acquireLockForWriter();
        boolean success = false;
        try {
            this.writerLockAcquired = true;
            this.cursor = this.pagedFile.io(0L, 2, cursorContext);
            this.cursorContext = cursorContext;
            long generation = this.generationSupplier.getAsLong();
            this.stableGeneration = Generation.stableGeneration(generation);
            this.unstableGeneration = Generation.unstableGeneration(generation);
            this.ratioToKeepInLeftOnSplit = ratioToKeepInLeftOnSplit;
            this.root = this.rootExchange.getRoot();
            if (!this.coordination.mustStartFromRoot()) {
                this.root.goTo(this.cursor);
                assert (PointerChecking.assertNoSuccessor(this.cursor, this.stableGeneration, this.unstableGeneration));
                this.treeLogic.initialize(this.cursor, ratioToKeepInLeftOnSplit);
            }
            success = true;
        }
        catch (Throwable e) {
            this.exceptionMessageAppender.accept(e);
            throw e;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    private void acquireLockForWriter() {
        this.checkpointLock.readLock().lock();
        try {
            if (this.parallel) {
                if (!this.writerLock.readLock().tryLock()) {
                    throw this.appendTreeInformation(new IllegalStateException("Single writer from GBPTree#writer() is active and cannot co-exist with parallel writers"));
                }
            } else if (!this.writerLock.writeLock().tryLock()) {
                throw this.appendTreeInformation(new IllegalStateException("Single writer from GBPTree#writer() is already acquired by someone else or one or more parallel writers are active"));
            }
        }
        catch (Throwable t) {
            this.checkpointLock.readLock().unlock();
            throw t;
        }
    }

    private <T extends Exception> T appendTreeInformation(T exception) {
        this.exceptionMessageAppender.accept(exception);
        return exception;
    }

    @Override
    public void put(K key, V value) {
        this.merge(key, value, ValueMergers.overwrite());
    }

    @Override
    public void merge(K key, V value, ValueMerger<K, V> valueMerger) {
        this.internalMerge(key, value, valueMerger, true);
    }

    @Override
    public void mergeIfExists(K key, V value, ValueMerger<K, V> valueMerger) {
        this.internalMerge(key, value, valueMerger, false);
    }

    private void internalMerge(K key, V value, ValueMerger<K, V> valueMerger, boolean createIfNotExists) {
        try {
            this.coordination.initialize();
            if (!this.goToRoot() || !this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, createIfNotExists, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                if (this.coordination.flipToPessimisticMode()) {
                    assert (this.structurePropagation.isEmpty());
                    this.releaseCursorLockIfNeeded();
                    if (!this.goToRoot() || !this.treeLogic.insert(this.cursor, this.structurePropagation, key, value, valueMerger, createIfNotExists, this.stableGeneration, this.unstableGeneration, this.cursorContext)) {
                        throw this.appendTreeInformation(new TreeInconsistencyException("Unable to insert key:%s value:%s in pessimistic mode", key, value));
                    }
                } else {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to insert key:%s value:%s in mode", key, value));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable t) {
            this.exceptionMessageAppender.accept(t);
            throw t;
        }
        finally {
            this.releaseCursorLockIfNeeded();
            this.coordination.reset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
    }

    private void releaseCursorLockIfNeeded() {
        if (this.coordination.mustStartFromRoot()) {
            this.cursor.unpin();
        }
    }

    private boolean goToRoot() throws IOException {
        if (!this.coordination.mustStartFromRoot()) {
            return true;
        }
        while (true) {
            this.coordination.beforeTraversingToChild(this.root.id(), 0);
            Root rootAfterLock = this.rootExchange.getRoot();
            if (rootAfterLock.equals(this.root)) break;
            this.coordination.reset();
            this.root = rootAfterLock;
        }
        TreeNode.goTo(this.cursor, "Root", this.root.id());
        assert (PointerChecking.assertNoSuccessor(this.cursor, this.stableGeneration, this.unstableGeneration));
        this.treeLogic.initialize(this.cursor, this.ratioToKeepInLeftOnSplit);
        int keyCount = TreeNode.keyCount(this.cursor);
        return this.coordination.arrivedAtChild(TreeNode.isInternal(this.cursor), this.bTreeNode.availableSpace(this.cursor, keyCount), TreeNode.generation(this.cursor) != this.unstableGeneration, keyCount);
    }

    private void setRoot(long rootPointer) throws IOException {
        long rootId = GenerationSafePointerPair.pointer(rootPointer);
        this.rootExchange.setRoot(new Root(rootId, this.unstableGeneration));
        this.treeLogic.initialize(this.cursor, this.ratioToKeepInLeftOnSplit);
    }

    @Override
    public V remove(K key) {
        InternalTreeLogic.RemoveResult result;
        TreeNode.ValueHolder<V> removedValue = new TreeNode.ValueHolder<V>(this.layout.newValue());
        try {
            this.coordination.initialize();
            if (!this.goToRoot() || (result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, removedValue, this.stableGeneration, this.unstableGeneration, this.cursorContext)) == InternalTreeLogic.RemoveResult.FAIL) {
                if (this.coordination.flipToPessimisticMode()) {
                    assert (this.structurePropagation.isEmpty());
                    this.releaseCursorLockIfNeeded();
                    if (!this.goToRoot() || (result = this.treeLogic.remove(this.cursor, this.structurePropagation, key, removedValue, this.stableGeneration, this.unstableGeneration, this.cursorContext)) == InternalTreeLogic.RemoveResult.FAIL) {
                        throw this.appendTreeInformation(new TreeInconsistencyException("Unable to remove key:%s in pessimistic mode", key));
                    }
                } else {
                    throw this.appendTreeInformation(new TreeInconsistencyException("Unable to remove key:%s in mode", key));
                }
            }
            this.handleStructureChanges(this.cursorContext);
        }
        catch (IOException e) {
            this.exceptionMessageAppender.accept(e);
            throw new UncheckedIOException(e);
        }
        catch (Throwable e) {
            this.exceptionMessageAppender.accept(e);
            throw e;
        }
        finally {
            this.releaseCursorLockIfNeeded();
            this.coordination.reset();
        }
        PointerChecking.checkOutOfBounds(this.cursor);
        return result == InternalTreeLogic.RemoveResult.REMOVED && removedValue.defined ? (V)removedValue.value : null;
    }

    private void handleStructureChanges(CursorContext cursorContext) throws IOException {
        if (this.structurePropagation.hasRightKeyInsert) {
            long newRootId = this.freeList.acquireNewId(this.stableGeneration, this.unstableGeneration, CursorCreator.bind(this.cursor));
            PageCursorUtil.goTo((PageCursor)this.cursor, (String)"new root", (long)newRootId);
            this.bTreeNode.initializeInternal(this.cursor, this.treeLogic.layerType, this.stableGeneration, this.unstableGeneration);
            this.bTreeNode.setChildAt(this.cursor, this.structurePropagation.midChild, 0, this.stableGeneration, this.unstableGeneration);
            this.bTreeNode.insertKeyAndRightChildAt(this.cursor, this.structurePropagation.rightKey, this.structurePropagation.rightChild, 0, 0, this.stableGeneration, this.unstableGeneration, cursorContext);
            TreeNode.setKeyCount(this.cursor, 1);
            this.setRoot(newRootId);
            this.monitor.treeGrowth();
        } else if (this.structurePropagation.hasMidChildUpdate) {
            this.setRoot(this.structurePropagation.midChild);
        }
        this.structurePropagation.clear();
    }

    @Override
    public void close() {
        if (!this.writerLockAcquired) {
            throw this.appendTreeInformation(new IllegalStateException(String.format("Tried to close writer, but writer is already closed. %s", this)));
        }
        this.closeCursor();
        if (this.parallel) {
            this.writerLock.readLock().unlock();
        } else {
            this.writerLock.writeLock().unlock();
        }
        this.checkpointLock.readLock().unlock();
        this.writerLockAcquired = false;
    }

    private void closeCursor() {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public String toString() {
        return this.coordination.toString();
    }
}

