/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.Comparator;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.InternalNodeBehaviour;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.util.VisibleForTesting;

abstract class TreeNode<KEY, VALUE> {
    protected final Layout<KEY, VALUE> layout;
    protected final LeafNodeBehaviour<KEY, VALUE> leaf;
    protected final InternalNodeBehaviour<KEY> internal;
    protected final int maxKeyCount;

    TreeNode(Layout<KEY, VALUE> layout, LeafNodeBehaviour<KEY, VALUE> leaf, InternalNodeBehaviour<KEY> internal) {
        this.layout = layout;
        this.leaf = leaf;
        this.internal = internal;
        this.maxKeyCount = Math.max(internal.maxKeyCount(), leaf.maxKeyCount());
    }

    final void initializeLeaf(PageCursor cursor, byte layerType, long stableGeneration, long unstableGeneration) {
        TreeNodeUtil.writeBaseHeader(cursor, (byte)1, layerType, stableGeneration, unstableGeneration);
        this.writeAdditionalHeader(cursor, Type.LEAF);
    }

    final void initializeInternal(PageCursor cursor, byte layerType, long stableGeneration, long unstableGeneration) {
        TreeNodeUtil.writeBaseHeader(cursor, (byte)0, layerType, stableGeneration, unstableGeneration);
        this.writeAdditionalHeader(cursor, Type.INTERNAL);
    }

    final void writeAdditionalHeader(PageCursor cursor, Type type) {
        switch (type) {
            case LEAF: {
                this.leaf.writeAdditionalHeader(cursor);
                break;
            }
            case INTERNAL: {
                this.internal.writeAdditionalHeader(cursor);
            }
        }
    }

    final long offloadIdAt(PageCursor cursor, int pos, Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.LEAF -> this.leaf.offloadIdAt(cursor, pos);
            case Type.INTERNAL -> this.internal.offloadIdAt(cursor, pos);
        };
    }

    final KEY keyAtLeaf(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        return this.leaf.keyAt(cursor, into, pos, cursorContext);
    }

    final KEY keyAtInternal(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        return this.internal.keyAt(cursor, into, pos, cursorContext);
    }

    final KEY keyAt(PageCursor cursor, KEY into, int pos, Type type, CursorContext cursorContext) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.LEAF -> this.leaf.keyAt(cursor, into, pos, cursorContext);
            case Type.INTERNAL -> this.internal.keyAt(cursor, into, pos, cursorContext);
        };
    }

    void keyValueAt(PageCursor cursor, KEY intoKey, ValueHolder<VALUE> intoValue, int pos, CursorContext cursorContext) throws IOException {
        this.leaf.keyValueAt(cursor, intoKey, intoValue, pos, cursorContext);
    }

    final <ROOT_KEY> void deepVisitValue(PageCursor cursor, int pos, GBPTreeVisitor<ROOT_KEY, KEY, VALUE> visitor) throws IOException {
        this.leaf.deepVisitValue(cursor, pos, visitor);
    }

    final void insertKeyAndRightChildAt(PageCursor cursor, KEY key, long child, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.internal.insertKeyAndRightChildAt(cursor, key, child, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.leaf.insertKeyValueAt(cursor, key, value, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final int removeKeyValueAt(PageCursor cursor, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        return this.leaf.removeKeyValueAt(cursor, pos, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final int removeKeyValues(PageCursor cursor, int fromPosInclusive, int toPosExclusive, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        return this.leaf.removeKeyValues(cursor, fromPosInclusive, toPosExclusive, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final void removeKeyAndRightChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.internal.removeKeyAndRightChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final void removeKeyAndLeftChildAt(PageCursor cursor, int keyPos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.internal.removeKeyAndLeftChildAt(cursor, keyPos, keyCount, stableGeneration, unstableGeneration, cursorContext);
    }

    final boolean setKeyAtInternal(PageCursor cursor, KEY key, int pos) {
        return this.internal.setKeyAt(cursor, key, pos);
    }

    ValueHolder<VALUE> valueAt(PageCursor cursor, ValueHolder<VALUE> value, int pos, CursorContext cursorContext) throws IOException {
        return this.leaf.valueAt(cursor, value, pos, cursorContext);
    }

    final boolean setValueAt(PageCursor cursor, VALUE value, int pos, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        return this.leaf.setValueAt(cursor, value, pos, cursorContext, stableGeneration, unstableGeneration);
    }

    final long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration) {
        return this.internal.childAt(cursor, pos, stableGeneration, unstableGeneration);
    }

    final long childAt(PageCursor cursor, int pos, long stableGeneration, long unstableGeneration, GBPTreeGenerationTarget generationTarget) {
        return this.internal.childAt(cursor, pos, stableGeneration, unstableGeneration, generationTarget);
    }

    final void setChildAt(PageCursor cursor, long child, int pos, long stableGeneration, long unstableGeneration) {
        this.internal.setChildAt(cursor, child, pos, stableGeneration, unstableGeneration);
    }

    final int keyValueSizeCap() {
        return this.leaf.keyValueSizeCap();
    }

    final int inlineKeyValueSizeCap() {
        return this.leaf.inlineKeyValueSizeCap();
    }

    final void validateKeyValueSize(KEY key, VALUE value) {
        this.leaf.validateKeyValueSize(key, value);
    }

    final boolean reasonableKeyCount(int keyCount) {
        return keyCount >= 0 && keyCount <= this.maxKeyCount;
    }

    final boolean reasonableChildCount(int childCount) {
        return this.internal.reasonableChildCount(childCount);
    }

    final int childOffset(int pos) {
        return this.internal.childOffset(pos);
    }

    final Comparator<KEY> keyComparator() {
        return this.layout;
    }

    final Overflow internalOverflow(PageCursor cursor, int currentKeyCount, KEY newKey) {
        return this.internal.overflow(cursor, currentKeyCount, newKey);
    }

    final Overflow leafOverflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        return this.leaf.overflow(cursor, currentKeyCount, newKey, newValue);
    }

    final int availableSpace(PageCursor cursor, int currentKeyCount, boolean isInternal) {
        return isInternal ? this.internal.availableSpace(cursor, currentKeyCount) : this.leaf.availableSpace(cursor, currentKeyCount);
    }

    final int totalSpaceOfKeyValue(KEY key, VALUE value) {
        return this.leaf.totalSpaceOfKeyValue(key, value);
    }

    final int totalSpaceOfKeyChild(KEY key) {
        return this.internal.totalSpaceOfKeyChild(key);
    }

    final int leafUnderflowThreshold() {
        return this.leaf.underflowThreshold();
    }

    final void defragmentLeaf(PageCursor cursor) {
        this.leaf.defragment(cursor);
    }

    final void defragmentInternal(PageCursor cursor) {
        this.internal.defragment(cursor);
    }

    final boolean leafUnderflow(PageCursor cursor, int keyCount) {
        return this.leaf.underflow(cursor, keyCount);
    }

    final int canRebalanceLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        return this.leaf.canRebalance(leftCursor, leftKeyCount, rightCursor, rightKeyCount);
    }

    final boolean canMergeLeaves(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        return this.leaf.canMerge(leftCursor, leftKeyCount, rightCursor, rightKeyCount);
    }

    final int findSplitter(PageCursor cursor, int keyCount, KEY newKey, VALUE newValue, int insertPos, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        return this.leaf.findSplitter(cursor, keyCount, newKey, newValue, insertPos, newSplitter, ratioToKeepInLeftOnSplit, cursorContext);
    }

    final void doSplitLeaf(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, int splitPos, double ratioToKeepInLeftOnSplit, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.leaf.doSplit(leftCursor, leftKeyCount, rightCursor, insertPos, newKey, newValue, newSplitter, splitPos, ratioToKeepInLeftOnSplit, stableGeneration, unstableGeneration, cursorContext);
    }

    final void doSplitInternal(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, long newRightChild, long stableGeneration, long unstableGeneration, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) throws IOException {
        this.internal.doSplit(leftCursor, leftKeyCount, rightCursor, insertPos, newKey, newRightChild, stableGeneration, unstableGeneration, newSplitter, ratioToKeepInLeftOnSplit, cursorContext);
    }

    final void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        this.leaf.moveKeyValuesFromLeftToRight(leftCursor, leftKeyCount, rightCursor, rightKeyCount, fromPosInLeftNode);
    }

    final void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.leaf.copyKeyValuesFromLeftToRight(leftCursor, leftKeyCount, rightCursor, rightKeyCount);
    }

    void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
        Type type = TreeNodeUtil.isInternal(cursor) ? Type.INTERNAL : Type.LEAF;
        switch (type) {
            case LEAF: {
                this.leaf.printNode(cursor, includeValue, includeAllocSpace, stableGeneration, unstableGeneration, cursorContext);
                break;
            }
            case INTERNAL: {
                this.internal.printNode(cursor, includeAllocSpace, stableGeneration, unstableGeneration, cursorContext);
            }
        }
    }

    String checkMetaConsistency(PageCursor cursor, int keyCount, Type type, GBPTreeConsistencyCheckVisitor visitor) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.LEAF -> this.leaf.checkMetaConsistency(cursor, keyCount, visitor);
            case Type.INTERNAL -> this.internal.checkMetaConsistency(cursor, keyCount, visitor);
        };
    }

    @VisibleForTesting
    final int internalMaxKeyCount() {
        return this.internal.maxKeyCount();
    }

    static enum Type {
        LEAF,
        INTERNAL;

    }

    static final class ValueHolder<VALUE> {
        VALUE value;
        boolean defined;

        public ValueHolder(VALUE value) {
            this(value, false);
        }

        public ValueHolder(VALUE value, boolean defined) {
            this.value = value;
            this.defined = defined;
        }
    }

    static enum Overflow {
        YES,
        NO,
        NO_NEED_DEFRAG;

    }
}

