/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

class StructurePropagation<KEY> {
    final KEY leftKey;
    final KEY rightKey;
    final KEY bubbleKey;
    long leftChild;
    long midChild;
    long rightChild;
    boolean hasLeftChildUpdate;
    boolean hasRightChildUpdate;
    boolean hasMidChildUpdate;
    boolean hasRightKeyInsert;
    KeyReplaceStrategy keyReplaceStrategy;
    boolean hasLeftKeyReplace;
    boolean hasRightKeyReplace;
    static final StructureUpdate UPDATE_LEFT_CHILD = (sp, childId) -> {
        sp.hasLeftChildUpdate = true;
        sp.leftChild = childId;
    };
    static final StructureUpdate UPDATE_MID_CHILD = (sp, childId) -> {
        sp.hasMidChildUpdate = true;
        sp.midChild = childId;
    };
    static final StructureUpdate UPDATE_RIGHT_CHILD = (sp, childId) -> {
        sp.hasRightChildUpdate = true;
        sp.rightChild = childId;
    };

    StructurePropagation(KEY leftKey, KEY rightKey, KEY bubbleKey) {
        this.leftKey = leftKey;
        this.rightKey = rightKey;
        this.bubbleKey = bubbleKey;
    }

    void clear() {
        this.hasLeftChildUpdate = false;
        this.hasRightChildUpdate = false;
        this.hasMidChildUpdate = false;
        this.hasRightKeyInsert = false;
        this.hasLeftKeyReplace = false;
        this.hasRightKeyReplace = false;
    }

    boolean isEmpty() {
        return !this.hasLeftChildUpdate && !this.hasRightChildUpdate && !this.hasMidChildUpdate && !this.hasRightKeyInsert && !this.hasLeftKeyReplace && !this.hasRightKeyReplace;
    }

    static interface StructureUpdate {
        public void update(StructurePropagation var1, long var2);
    }

    static enum KeyReplaceStrategy {
        REPLACE,
        BUBBLE;

    }
}

