/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LeafNodeBehaviour;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeNodeUtil;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class LeafNodeFixedSize<KEY, VALUE>
implements LeafNodeBehaviour<KEY, VALUE> {
    private final int maxKeyCount;
    private final int keySize;
    private final int valueSize;
    private final int halfSpace;
    protected final Layout<KEY, VALUE> layout;
    private final int payloadSize;

    LeafNodeFixedSize(int pageSize, Layout<KEY, VALUE> layout) {
        this(pageSize, layout, 0);
    }

    LeafNodeFixedSize(int payloadSize, Layout<KEY, VALUE> layout, int valuePadding) {
        this.payloadSize = payloadSize;
        this.layout = layout;
        this.keySize = layout.keySize(null);
        this.valueSize = layout.valueSize(null) + valuePadding;
        this.maxKeyCount = Math.floorDiv(payloadSize - 82, this.keySize + this.valueSize);
        int halfKeyCount = (this.maxKeyCount + 1) / 2;
        this.halfSpace = halfKeyCount * (this.keySize + this.valueSize);
        if (this.maxKeyCount < 2) {
            throw new MetadataMismatchException(String.format("A page size of %d would only fit %d leaf keys (keySize:%d, valueSize:%d), minimum is 2", payloadSize, this.maxKeyCount, this.keySize, this.valueSize));
        }
    }

    @Override
    public void writeAdditionalHeader(PageCursor cursor) {
    }

    @Override
    public long offloadIdAt(PageCursor cursor, int pos) {
        return -1L;
    }

    @Override
    public KEY keyAt(PageCursor cursor, KEY into, int pos, CursorContext cursorContext) {
        cursor.setOffset(this.keyOffset(pos));
        this.layout.readKey(cursor, into, -1);
        return into;
    }

    @Override
    public void keyValueAt(PageCursor cursor, KEY intoKey, TreeNode.ValueHolder<VALUE> intoValue, int pos, CursorContext cursorContext) throws IOException {
        this.keyAt(cursor, intoKey, pos, cursorContext);
        this.valueAt(cursor, intoValue, pos, cursorContext);
    }

    @Override
    public void insertKeyValueAt(PageCursor cursor, KEY key, VALUE value, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.insertKeyAt(cursor, key, pos, keyCount);
        this.insertValueAt(cursor, value, pos, keyCount, cursorContext, stableGeneration, unstableGeneration);
    }

    @Override
    public int removeKeyValueAt(PageCursor cursor, int pos, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        this.removeKeyAt(cursor, pos, keyCount);
        this.removeValueAt(cursor, pos, keyCount);
        return keyCount - 1;
    }

    @Override
    public int removeKeyValues(PageCursor cursor, int fromPosInclusive, int toPosExclusive, int keyCount, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        TreeNodeUtil.removeSlotsAt(cursor, fromPosInclusive, toPosExclusive, keyCount, this.keyOffset(0), this.keySize);
        TreeNodeUtil.removeSlotsAt(cursor, fromPosInclusive, toPosExclusive, keyCount, this.valueOffset(0), this.valueSize);
        return keyCount - toPosExclusive + fromPosInclusive;
    }

    @Override
    public TreeNode.ValueHolder<VALUE> valueAt(PageCursor cursor, TreeNode.ValueHolder<VALUE> value, int pos, CursorContext cursorContext) throws IOException {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.readValue(cursor, value.value, -1);
        value.defined = true;
        return value;
    }

    @Override
    public boolean setValueAt(PageCursor cursor, VALUE value, int pos, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        cursor.setOffset(this.valueOffset(pos));
        this.layout.writeValue(cursor, value);
        return true;
    }

    @Override
    public int keyValueSizeCap() {
        return -1;
    }

    @Override
    public int inlineKeyValueSizeCap() {
        return -1;
    }

    @Override
    public void validateKeyValueSize(KEY key, VALUE value) {
    }

    private void insertKeyAt(PageCursor cursor, KEY key, int pos, int keyCount) {
        this.insertKeySlotsAt(cursor, pos, 1, keyCount);
        cursor.setOffset(this.keyOffset(pos));
        this.layout.writeKey(cursor, key);
    }

    @Override
    public int maxKeyCount() {
        return this.maxKeyCount;
    }

    private void removeKeyAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeUtil.removeSlotAt(cursor, pos, keyCount, this.keyOffset(0), this.keySize);
    }

    private void insertKeyValueSlots(PageCursor cursor, int numberOfSlots, int keyCount) {
        this.insertKeySlotsAt(cursor, 0, numberOfSlots, keyCount);
        this.insertValueSlotsAt(cursor, 0, numberOfSlots, keyCount);
    }

    protected void insertValueAt(PageCursor cursor, VALUE value, int pos, int keyCount, CursorContext cursorContext, long stableGeneration, long unstableGeneration) throws IOException {
        this.insertValueSlotsAt(cursor, pos, 1, keyCount);
        this.setValueAt(cursor, value, pos, cursorContext, stableGeneration, unstableGeneration);
    }

    private void removeValueAt(PageCursor cursor, int pos, int keyCount) {
        TreeNodeUtil.removeSlotAt(cursor, pos, keyCount, this.valueOffset(0), this.valueSize);
    }

    private void insertKeySlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeUtil.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.keyOffset(0), this.keySize);
    }

    protected void insertValueSlotsAt(PageCursor cursor, int pos, int numberOfSlots, int keyCount) {
        TreeNodeUtil.insertSlotsAt(cursor, pos, numberOfSlots, keyCount, this.valueOffset(0), this.valueSize);
    }

    private int keyOffset(int pos) {
        return 82 + pos * this.keySize;
    }

    protected int valueOffset(int pos) {
        return 82 + this.maxKeyCount * this.keySize + pos * this.valueSize;
    }

    @Override
    public TreeNode.Overflow overflow(PageCursor cursor, int currentKeyCount, KEY newKey, VALUE newValue) {
        return currentKeyCount + 1 > this.maxKeyCount ? TreeNode.Overflow.YES : TreeNode.Overflow.NO;
    }

    @Override
    public int availableSpace(PageCursor cursor, int currentKeyCount) {
        return (this.maxKeyCount - currentKeyCount) * (this.keySize + this.valueSize);
    }

    @Override
    public int totalSpaceOfKeyValue(KEY key, VALUE value) {
        return this.keySize + this.valueSize;
    }

    @Override
    public void printNode(PageCursor cursor, boolean includeValue, boolean includeAllocSpace, long stableGeneration, long unstableGeneration, CursorContext cursorContext) {
    }

    @Override
    public String checkMetaConsistency(PageCursor cursor, int keyCount, GBPTreeConsistencyCheckVisitor visitor) {
        return "";
    }

    @Override
    public int underflowThreshold() {
        return this.halfSpace;
    }

    @Override
    public void defragment(PageCursor cursor) {
    }

    @Override
    public boolean underflow(PageCursor cursor, int keyCount) {
        return this.availableSpace(cursor, keyCount) > this.halfSpace;
    }

    @Override
    public int canRebalance(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        if (leftKeyCount + rightKeyCount >= this.maxKeyCount) {
            int totalKeyCount = rightKeyCount + leftKeyCount;
            int moveFromPosition = totalKeyCount / 2;
            return leftKeyCount - moveFromPosition;
        }
        return -1;
    }

    @Override
    public boolean canMerge(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        return leftKeyCount + rightKeyCount <= this.maxKeyCount;
    }

    @Override
    public int findSplitter(PageCursor cursor, int keyCount, KEY newKey, VALUE newValue, int insertPos, KEY newSplitter, double ratioToKeepInLeftOnSplit, CursorContext cursorContext) {
        int keyCountAfterInsert = keyCount + 1;
        int splitPos = TreeNodeUtil.splitPos(keyCountAfterInsert, ratioToKeepInLeftOnSplit);
        if (splitPos == insertPos) {
            this.layout.copyKey(newKey, newSplitter);
        } else {
            this.keyAt(cursor, newSplitter, insertPos < splitPos ? splitPos - 1 : splitPos, cursorContext);
        }
        return splitPos;
    }

    @Override
    public void doSplit(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int insertPos, KEY newKey, VALUE newValue, KEY newSplitter, int splitPos, double ratioToKeepInLeftOnSplit, long stableGeneration, long unstableGeneration, CursorContext cursorContext) throws IOException {
        int keyCountAfterInsert = leftKeyCount + 1;
        int rightKeyCount = keyCountAfterInsert - splitPos;
        if (insertPos < splitPos) {
            this.copyKeysAndValues(leftCursor, splitPos - 1, rightCursor, 0, rightKeyCount);
            this.insertKeyValueAt(leftCursor, newKey, newValue, insertPos, splitPos - 1, stableGeneration, unstableGeneration, cursorContext);
        } else {
            int countBeforePos = insertPos - splitPos;
            if (countBeforePos > 0) {
                this.copyKeysAndValues(leftCursor, splitPos, rightCursor, 0, countBeforePos);
            }
            this.insertKeyValueAt(rightCursor, newKey, newValue, countBeforePos, countBeforePos, stableGeneration, unstableGeneration, cursorContext);
            int countAfterPos = leftKeyCount - insertPos;
            if (countAfterPos > 0) {
                this.copyKeysAndValues(leftCursor, insertPos, rightCursor, countBeforePos + 1, countAfterPos);
            }
        }
        TreeNodeUtil.setKeyCount(leftCursor, splitPos);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount);
    }

    @Override
    public void moveKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount, int fromPosInLeftNode) {
        int numberOfKeysToMove = leftKeyCount - fromPosInLeftNode;
        this.insertKeyValueSlots(rightCursor, numberOfKeysToMove, rightKeyCount);
        this.copyKeysAndValues(leftCursor, fromPosInLeftNode, rightCursor, 0, numberOfKeysToMove);
        TreeNodeUtil.setKeyCount(leftCursor, leftKeyCount - numberOfKeysToMove);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount + numberOfKeysToMove);
    }

    @Override
    public void copyKeyValuesFromLeftToRight(PageCursor leftCursor, int leftKeyCount, PageCursor rightCursor, int rightKeyCount) {
        this.insertKeyValueSlots(rightCursor, leftKeyCount, rightKeyCount);
        this.copyKeysAndValues(leftCursor, 0, rightCursor, 0, leftKeyCount);
        TreeNodeUtil.setKeyCount(rightCursor, rightKeyCount + leftKeyCount);
    }

    private void copyKeysAndValues(PageCursor fromCursor, int fromPos, PageCursor toCursor, int toPos, int count) {
        fromCursor.copyTo(this.keyOffset(fromPos), toCursor, this.keyOffset(toPos), count * this.keySize);
        int valueLength = count * this.valueSize;
        if (valueLength > 0) {
            fromCursor.copyTo(this.valueOffset(fromPos), toCursor, this.valueOffset(toPos), valueLength);
        }
    }

    public String toString() {
        return "LeafFixedSize[payloadSize:" + this.payloadSize + ", maxKeys:" + this.maxKeyCount + ", keySize:" + this.keySize + ", valueSize:" + this.valueSize + "]";
    }

    @Override
    public <ROOT_KEY> void deepVisitValue(PageCursor cursor, int pos, GBPTreeVisitor<ROOT_KEY, KEY, VALUE> visitor) throws IOException {
    }
}

