/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.neo4j.index.internal.gbptree.GBPTreeConsistencyCheckVisitor;
import org.neo4j.index.internal.gbptree.GBPTreeGenerationTarget;
import org.neo4j.index.internal.gbptree.GBPTreePointerType;
import org.neo4j.index.internal.gbptree.GenerationKeeper;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.IdProvider;
import org.neo4j.index.internal.gbptree.KeyRange;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.RightmostInChain;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;

class GBPTreeConsistencyChecker<KEY> {
    private final TreeNode<KEY, ?> node;
    private final Comparator<KEY> comparator;
    private final Layout<KEY, ?> layout;
    private final List<RightmostInChain> rightmostPerLevel = new ArrayList<RightmostInChain>();
    private final IdProvider idProvider;
    private final long lastId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final boolean reportDirty;
    private final GenerationKeeper generationTarget = new GenerationKeeper();
    private final MutableLongList offloadIds = new LongArrayList();

    GBPTreeConsistencyChecker(TreeNode<KEY, ?> node, Layout<KEY, ?> layout, IdProvider idProvider, long stableGeneration, long unstableGeneration, boolean reportDirty) {
        this.node = node;
        this.comparator = node.keyComparator();
        this.layout = layout;
        this.idProvider = idProvider;
        this.lastId = idProvider.lastId();
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.reportDirty = reportDirty;
    }

    public void check(Path file, PageCursor cursor, Root root, GBPTreeConsistencyCheckVisitor<KEY> visitor, CursorContext cursorContext) throws IOException {
        long highId = this.lastId + 1L;
        BitSet seenIds = new BitSet(Math.toIntExact(highId));
        FreelistSeenIdsVisitor<KEY> freelistSeenIdsVisitor = new FreelistSeenIdsVisitor<KEY>(file, seenIds, this.lastId, visitor);
        this.idProvider.visitFreelist(freelistSeenIdsVisitor, cursorContext);
        long rootGeneration = root.goTo(cursor);
        KeyRange<Object> openRange = new KeyRange<Object>(-1, -1L, this.comparator, null, null, this.layout, null);
        this.checkSubtree(file, cursor, openRange, -1L, rootGeneration, GBPTreePointerType.noPointer(), 0, visitor, seenIds, cursorContext);
        this.rightmostPerLevel.forEach(rightmost -> rightmost.assertLast(visitor));
        GBPTreeConsistencyChecker.assertAllIdsOccupied(file, highId, seenIds, visitor);
        root.goTo(cursor);
    }

    private static <KEY> void assertAllIdsOccupied(Path file, long highId, BitSet seenIds, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        long expectedNumberOfPages = highId - 3L;
        if ((long)seenIds.cardinality() != expectedNumberOfPages) {
            for (int index = 3; index >= 0 && (long)index < highId; ++index) {
                if ((index = seenIds.nextClearBit(index)) == -1 || (long)index >= highId) continue;
                visitor.unusedPage(index, file);
            }
        }
    }

    private static <KEY> void addToSeenList(Path file, BitSet target, long id, long lastId, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        int index = Math.toIntExact(id);
        if (target.get(index)) {
            visitor.pageIdSeenMultipleTimes(id, file);
        }
        if (id > lastId) {
            visitor.pageIdExceedLastId(lastId, id, file);
        }
        target.set(index);
    }

    private void checkSubtree(Path file, PageCursor cursor, KeyRange<KEY> range, long parentNode, long pointerGeneration, GBPTreePointerType parentPointerType, int level, GBPTreeConsistencyCheckVisitor<KEY> visitor, BitSet seenIds, CursorContext cursorContext) throws IOException {
        boolean consistentNodeMeta;
        String nodeMetaReport;
        boolean isInternal;
        byte treeNodeType;
        byte nodeType;
        int keyCount;
        long successor;
        long currentNodeGeneration;
        long rightSiblingPointerGeneration;
        long rightSiblingPointer;
        long leftSiblingPointerGeneration;
        long leftSiblingPointer;
        long pageId = cursor.getCurrentPageId();
        GBPTreeConsistencyChecker.addToSeenList(file, seenIds, pageId, this.lastId, visitor);
        if (range.hasPageIdInStack(pageId)) {
            visitor.childNodeFoundAmongParentNodes(range, level, pageId, file);
            return;
        }
        do {
            leftSiblingPointer = TreeNode.leftSibling(cursor, this.stableGeneration, this.unstableGeneration, this.generationTarget);
            leftSiblingPointerGeneration = this.generationTarget.generation;
            rightSiblingPointer = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration, this.generationTarget);
            rightSiblingPointerGeneration = this.generationTarget.generation;
            leftSiblingPointer = GenerationSafePointerPair.pointer(leftSiblingPointer);
            rightSiblingPointer = GenerationSafePointerPair.pointer(rightSiblingPointer);
            currentNodeGeneration = TreeNode.generation(cursor);
            successor = TreeNode.successor(cursor, this.stableGeneration, this.unstableGeneration, this.generationTarget);
            keyCount = TreeNode.keyCount(cursor);
            nodeType = TreeNode.nodeType(cursor);
            treeNodeType = TreeNode.treeNodeType(cursor);
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        if (nodeType != 1) {
            visitor.notATreeNode(pageId, file);
            return;
        }
        boolean isLeaf = treeNodeType == 1;
        boolean bl = isInternal = treeNodeType == 0;
        if (!isInternal && !isLeaf) {
            visitor.unknownTreeNodeType(pageId, treeNodeType, file);
            return;
        }
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.leftSibling(), 34, visitor, this.reportDirty);
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.rightSibling(), 10, visitor, this.reportDirty);
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.successor(), 58, visitor, this.reportDirty);
        boolean reasonableKeyCount = this.node.reasonableKeyCount(keyCount);
        if (!reasonableKeyCount) {
            visitor.unreasonableKeyCount(pageId, keyCount, file);
        } else {
            this.assertKeyOrder(file, cursor, range, keyCount, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL, this.offloadIds, visitor, cursorContext);
        }
        this.offloadIds.forEach((LongProcedure & Serializable)id -> GBPTreeConsistencyChecker.addToSeenList(file, seenIds, id, this.lastId, visitor));
        do {
            nodeMetaReport = this.node.checkMetaConsistency(cursor, keyCount, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL, visitor);
            consistentNodeMeta = nodeMetaReport.isEmpty();
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        if (!consistentNodeMeta) {
            visitor.nodeMetaInconsistency(pageId, nodeMetaReport, file);
        }
        GBPTreeConsistencyChecker.assertPointerGenerationMatchesGeneration(file, parentPointerType, parentNode, pageId, pointerGeneration, currentNodeGeneration, visitor);
        this.assertSiblings(file, cursor, currentNodeGeneration, leftSiblingPointer, leftSiblingPointerGeneration, rightSiblingPointer, rightSiblingPointerGeneration, level, visitor);
        this.checkSuccessorPointerGeneration(file, cursor, successor, visitor);
        if (isInternal && reasonableKeyCount && consistentNodeMeta) {
            this.assertSubtrees(file, cursor, range, keyCount, level, visitor, seenIds, cursorContext);
        }
    }

    private static <KEY> void assertPointerGenerationMatchesGeneration(Path file, GBPTreePointerType pointerType, long sourceNode, long pointer, long pointerGeneration, long targetNodeGeneration, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        if (targetNodeGeneration > pointerGeneration) {
            visitor.pointerHasLowerGenerationThanNode(pointerType, sourceNode, pointerGeneration, pointer, targetNodeGeneration, file);
        }
    }

    private void checkSuccessorPointerGeneration(Path file, PageCursor cursor, long successor, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        if (TreeNode.isNode(successor)) {
            visitor.pointerToOldVersionOfTreeNode(cursor.getCurrentPageId(), GenerationSafePointerPair.pointer(successor), file);
        }
    }

    private void assertSiblings(Path file, PageCursor cursor, long currentNodeGeneration, long leftSiblingPointer, long leftSiblingPointerGeneration, long rightSiblingPointer, long rightSiblingPointerGeneration, int level, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
        for (int i = this.rightmostPerLevel.size(); i <= level; ++i) {
            this.rightmostPerLevel.add(i, new RightmostInChain(file));
        }
        RightmostInChain rightmost = this.rightmostPerLevel.get(level);
        rightmost.assertNext(cursor, currentNodeGeneration, leftSiblingPointer, leftSiblingPointerGeneration, rightSiblingPointer, rightSiblingPointerGeneration, visitor);
    }

    private void assertSubtrees(Path file, PageCursor cursor, KeyRange<KEY> range, int keyCount, int level, GBPTreeConsistencyCheckVisitor<KEY> visitor, BitSet seenIds, CursorContext cursorContext) throws IOException {
        KeyRange<Object> childRange;
        long childGeneration;
        long child;
        int pos;
        long pageId = cursor.getCurrentPageId();
        Object prev = null;
        KEY readKey = this.layout.newKey();
        for (pos = 0; pos < keyCount; ++pos) {
            GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.child(pos), this.node.childOffset(pos), visitor, this.reportDirty);
            do {
                child = this.childAt(cursor, pos, this.generationTarget);
                childGeneration = this.generationTarget.generation;
                this.node.keyAt(cursor, readKey, pos, TreeNode.Type.INTERNAL, cursorContext);
            } while (cursor.shouldRetry());
            GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
            childRange = range.newSubRange(level, pageId).restrictRight(readKey);
            if (pos > 0) {
                childRange = childRange.restrictLeft(prev);
            }
            TreeNode.goTo(cursor, "child at pos " + pos, child);
            this.checkSubtree(file, cursor, childRange, pageId, childGeneration, GBPTreePointerType.child(pos), level + 1, visitor, seenIds, cursorContext);
            TreeNode.goTo(cursor, "parent", pageId);
            if (pos == 0) {
                prev = this.layout.newKey();
            }
            this.layout.copyKey(readKey, prev);
        }
        GBPTreeConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(file, cursor, this.stableGeneration, this.unstableGeneration, GBPTreePointerType.child(pos), this.node.childOffset(pos), visitor, this.reportDirty);
        do {
            child = this.childAt(cursor, pos, this.generationTarget);
            childGeneration = this.generationTarget.generation;
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        TreeNode.goTo(cursor, "child at pos " + pos, child);
        childRange = range.newSubRange(level, pageId).restrictLeft(prev);
        this.checkSubtree(file, cursor, childRange, pageId, childGeneration, GBPTreePointerType.child(pos), level + 1, visitor, seenIds, cursorContext);
        TreeNode.goTo(cursor, "parent", pageId);
    }

    private static void checkAfterShouldRetry(PageCursor cursor) throws CursorException {
        PageCursorUtil.checkOutOfBounds(cursor);
        cursor.checkAndClearCursorException();
    }

    private long childAt(PageCursor cursor, int pos, GBPTreeGenerationTarget childGeneration) {
        return this.node.childAt(cursor, pos, this.stableGeneration, this.unstableGeneration, childGeneration);
    }

    private void assertKeyOrder(Path file, PageCursor cursor, KeyRange<KEY> range, int keyCount, TreeNode.Type type, MutableLongList offloadIds, GBPTreeConsistencyCheckVisitor<KEY> visitor, CursorContext cursorContext) throws IOException {
        DelayedVisitor<KEY> delayedVisitor = new DelayedVisitor<KEY>(file);
        do {
            delayedVisitor.clear();
            offloadIds.clear();
            KEY prev = this.layout.newKey();
            KEY readKey = this.layout.newKey();
            boolean first = true;
            for (int pos = 0; pos < keyCount; ++pos) {
                this.node.keyAt(cursor, readKey, pos, type, cursorContext);
                if (!range.inRange(readKey)) {
                    KEY keyCopy = this.layout.newKey();
                    this.layout.copyKey(readKey, keyCopy);
                    delayedVisitor.keysLocatedInWrongNode(range, keyCopy, pos, keyCount, cursor.getCurrentPageId(), file);
                }
                if (!first) {
                    if (this.comparator.compare(prev, readKey) >= 0) {
                        delayedVisitor.keysOutOfOrderInNode(cursor.getCurrentPageId(), file);
                    }
                } else {
                    first = false;
                }
                this.layout.copyKey(readKey, prev);
                long offloadId = this.node.offloadIdAt(cursor, pos, type);
                if (offloadId == -1L) continue;
                offloadIds.add(offloadId);
            }
        } while (cursor.shouldRetry());
        GBPTreeConsistencyChecker.checkAfterShouldRetry(cursor);
        delayedVisitor.report(visitor);
    }

    static <KEY> void assertNoCrashOrBrokenPointerInGSPP(Path file, PageCursor cursor, long stableGeneration, long unstableGeneration, GBPTreePointerType pointerType, int offset, GBPTreeConsistencyCheckVisitor<KEY> visitor, boolean reportDirty) throws IOException {
        byte stateB;
        long pointerB;
        long readPointerB;
        long generationB;
        byte stateA;
        long pointerA;
        long readPointerA;
        long generationA;
        long currentNodeId = cursor.getCurrentPageId();
        do {
            cursor.setOffset(offset);
            generationA = GenerationSafePointer.readGeneration(cursor);
            readPointerA = GenerationSafePointer.readPointer(cursor);
            pointerA = GenerationSafePointerPair.pointer(readPointerA);
            short checksumA = GenerationSafePointer.readChecksum(cursor);
            boolean correctChecksumA = GenerationSafePointer.checksumOf(generationA, readPointerA) == checksumA;
            stateA = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, readPointerA, correctChecksumA);
            generationB = GenerationSafePointer.readGeneration(cursor);
            readPointerB = GenerationSafePointer.readPointer(cursor);
            pointerB = GenerationSafePointerPair.pointer(readPointerA);
            short checksumB = GenerationSafePointer.readChecksum(cursor);
            boolean correctChecksumB = GenerationSafePointer.checksumOf(generationB, readPointerB) == checksumB;
            stateB = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, readPointerB, correctChecksumB);
        } while (cursor.shouldRetry());
        if (reportDirty && (stateA == 2 || stateB == 2)) {
            visitor.crashedPointer(currentNodeId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
        }
        if (stateA == 3 || stateB == 3) {
            visitor.brokenPointer(currentNodeId, pointerType, generationA, readPointerA, pointerA, stateA, generationB, readPointerB, pointerB, stateB, file);
        }
    }

    private static class FreelistSeenIdsVisitor<KEY>
    implements IdProvider.IdProviderVisitor {
        private final Path path;
        private final BitSet seenIds;
        private final long lastId;
        private final GBPTreeConsistencyCheckVisitor<KEY> visitor;

        private FreelistSeenIdsVisitor(Path path, BitSet seenIds, long lastId, GBPTreeConsistencyCheckVisitor<KEY> visitor) {
            this.path = path;
            this.seenIds = seenIds;
            this.lastId = lastId;
            this.visitor = visitor;
        }

        @Override
        public void beginFreelistPage(long pageId) {
            GBPTreeConsistencyChecker.addToSeenList(this.path, this.seenIds, pageId, this.lastId, this.visitor);
        }

        @Override
        public void endFreelistPage(long pageId) {
        }

        @Override
        public void freelistEntry(long pageId, long generation, int pos) {
            GBPTreeConsistencyChecker.addToSeenList(this.path, this.seenIds, pageId, this.lastId, this.visitor);
        }
    }

    private static class DelayedVisitor<KEY>
    extends GBPTreeConsistencyCheckVisitor.Adaptor<KEY> {
        private final Path path;
        MutableLongList keysOutOfOrder = LongLists.mutable.empty();
        MutableList<KeyInWrongNode<KEY>> keysLocatedInWrongNode = Lists.mutable.empty();

        DelayedVisitor(Path path) {
            this.path = path;
        }

        @Override
        public void keysOutOfOrderInNode(long pageId, Path file) {
            this.keysOutOfOrder.add(pageId);
        }

        @Override
        public void keysLocatedInWrongNode(KeyRange<KEY> range, KEY key, int pos, int keyCount, long pageId, Path file) {
            this.keysLocatedInWrongNode.add(new KeyInWrongNode<KEY>(pageId, range, key, pos, keyCount));
        }

        void clear() {
            this.keysOutOfOrder.clear();
            this.keysLocatedInWrongNode.clear();
        }

        void report(GBPTreeConsistencyCheckVisitor<KEY> visitor) {
            if (this.keysOutOfOrder.notEmpty()) {
                this.keysOutOfOrder.forEach((LongProcedure & Serializable)pageId -> visitor.keysOutOfOrderInNode(pageId, this.path));
            }
            if (this.keysLocatedInWrongNode.notEmpty()) {
                this.keysLocatedInWrongNode.forEach((Procedure & Serializable)keyInWrongNode -> visitor.keysLocatedInWrongNode(keyInWrongNode.range, keyInWrongNode.key, keyInWrongNode.pos, keyInWrongNode.keyCount, keyInWrongNode.pageId, this.path));
            }
        }

        private static class KeyInWrongNode<KEY> {
            final long pageId;
            final KeyRange<KEY> range;
            final KEY key;
            final int pos;
            final int keyCount;

            private KeyInWrongNode(long pageId, KeyRange<KEY> range, KEY key, int pos, int keyCount) {
                this.pageId = pageId;
                this.range = range;
                this.key = key;
                this.pos = pos;
                this.keyCount = keyCount;
            }
        }
    }
}

