/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.helpers.DatabaseReadOnlyChecker;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;

public class GBPTreeBootstrapper
implements Closeable {
    private static final int MAX_PAGE_SIZE = (int)ByteUnit.mebiBytes((long)4L);
    private final FileSystemAbstraction fs;
    private final JobScheduler jobScheduler;
    private final LayoutBootstrapper layoutBootstrapper;
    private final DatabaseReadOnlyChecker readOnlyChecker;
    private final PageCacheTracer pageCacheTracer;
    private PageCache pageCache;

    public GBPTreeBootstrapper(FileSystemAbstraction fs, JobScheduler jobScheduler, LayoutBootstrapper layoutBootstrapper, DatabaseReadOnlyChecker readOnlyChecker, PageCacheTracer pageCacheTracer) {
        this.fs = fs;
        this.jobScheduler = jobScheduler;
        this.layoutBootstrapper = layoutBootstrapper;
        this.readOnlyChecker = readOnlyChecker;
        this.pageCacheTracer = pageCacheTracer;
    }

    public Bootstrap bootstrapTree(Path file, OpenOption ... additionalOptions) {
        try {
            this.instantiatePageCache(this.fs, this.jobScheduler, 8192);
            MetaVisitor<?, ?> metaVisitor = this.visitMeta(file);
            Meta meta = metaVisitor.meta;
            if (!GBPTreeBootstrapper.isReasonablePageSize(meta.getPageSize())) {
                throw new MetadataMismatchException("Unexpected page size " + meta.getPageSize());
            }
            if (meta.getPageSize() != this.pageCache.pageSize()) {
                this.instantiatePageCache(this.fs, this.jobScheduler, meta.getPageSize());
                metaVisitor = this.visitMeta(file);
                meta = metaVisitor.meta;
            }
            StateVisitor<?, ?> stateVisitor = this.visitState(file);
            Pair<TreeState, TreeState> statePair = stateVisitor.statePair;
            TreeState state = TreeStatePair.selectNewestValidState(statePair);
            Layout<?, ?> layout = this.layoutBootstrapper.create(file, this.pageCache, meta);
            GBPTree tree = new GBPTree(this.pageCache, file, layout, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.ignore(), this.readOnlyChecker, this.pageCacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.of((Object[])additionalOptions), "neo4j", file.getFileName().toString());
            return new SuccessfulBootstrap(tree, layout, state, meta);
        }
        catch (Exception e) {
            return new FailedBootstrap(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.closePageCache();
    }

    private MetaVisitor<?, ?> visitMeta(Path file) throws IOException {
        MetaVisitor metaVisitor = new MetaVisitor();
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer("TreeBootstrap"));){
            GBPTreeStructure.visitMeta(this.pageCache, file, metaVisitor, file.getFileName().toString(), cursorContext);
        }
        return metaVisitor;
    }

    private StateVisitor<?, ?> visitState(Path file) throws IOException {
        StateVisitor stateVisitor = new StateVisitor();
        try (CursorContext cursorContext = new CursorContext(this.pageCacheTracer.createPageCursorTracer("TreeBootstrap"));){
            GBPTreeStructure.visitState(this.pageCache, file, stateVisitor, file.getFileName().toString(), cursorContext);
        }
        return stateVisitor;
    }

    private void instantiatePageCache(FileSystemAbstraction fs, JobScheduler jobScheduler, int pageSize) {
        if (this.pageCache != null && this.pageCache.pageSize() == pageSize) {
            return;
        }
        this.closePageCache();
        SingleFilePageSwapperFactory swapper = new SingleFilePageSwapperFactory(fs);
        long expectedMemory = Math.max(MuninnPageCache.memoryRequiredForPages((long)100L), 3L * (long)pageSize);
        this.pageCache = new MuninnPageCache((PageSwapperFactory)swapper, jobScheduler, MuninnPageCache.config((MemoryAllocator)MemoryAllocator.createAllocator((long)expectedMemory, (MemoryTracker)EmptyMemoryTracker.INSTANCE)).pageSize(pageSize));
    }

    private void closePageCache() {
        if (this.pageCache != null) {
            this.pageCache.close();
            this.pageCache = null;
        }
    }

    private static boolean isReasonablePageSize(int number) {
        return Numbers.isPowerOfTwo((long)number) && GBPTreeBootstrapper.isReasonableSize(number);
    }

    private static boolean isReasonableSize(int pageSize) {
        return pageSize <= MAX_PAGE_SIZE;
    }

    private static class StateVisitor<KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
        private Pair<TreeState, TreeState> statePair;

        private StateVisitor() {
        }

        @Override
        public void treeState(Pair<TreeState, TreeState> statePair) {
            this.statePair = statePair;
        }
    }

    private static class MetaVisitor<KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
        private Meta meta;

        private MetaVisitor() {
        }

        @Override
        public void meta(Meta meta) {
            this.meta = meta;
        }
    }

    private static class SuccessfulBootstrap
    implements Bootstrap {
        private final GBPTree<?, ?> tree;
        private final Layout<?, ?> layout;
        private final TreeState state;
        private final Meta meta;

        SuccessfulBootstrap(GBPTree<?, ?> tree, Layout<?, ?> layout, TreeState state, Meta meta) {
            this.tree = tree;
            this.layout = layout;
            this.state = state;
            this.meta = meta;
        }

        @Override
        public boolean isTree() {
            return true;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            return this.tree;
        }

        @Override
        public Layout<?, ?> getLayout() {
            return this.layout;
        }

        @Override
        public TreeState getState() {
            return this.state;
        }

        @Override
        public Meta getMeta() {
            return this.meta;
        }
    }

    private static class FailedBootstrap
    implements Bootstrap {
        private final Throwable cause;

        FailedBootstrap(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public boolean isTree() {
            return false;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public Layout<?, ?> getLayout() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public TreeState getState() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public Meta getMeta() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }
    }

    public static interface Bootstrap {
        public boolean isTree();

        public GBPTree<?, ?> getTree();

        public Layout<?, ?> getLayout();

        public TreeState getState();

        public Meta getMeta();
    }
}

