/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.util.VisibleForTesting;

class GBPTreeLock {
    private static final long stateOffset = UnsafeUtil.getFieldOffset(GBPTreeLock.class, (String)"state");
    private static final long writerLockBit = 1L;
    private static final long cleanerLockBit = 2L;
    private volatile long state;

    GBPTreeLock() {
    }

    GBPTreeLock copy() {
        GBPTreeLock copy = new GBPTreeLock();
        copy.state = this.state;
        return copy;
    }

    void writerLock() {
        this.doLock(1L);
    }

    void writerUnlock() {
        this.doUnlock(1L);
    }

    void cleanerLock() {
        this.doLock(2L);
    }

    void cleanerUnlock() {
        this.doUnlock(2L);
    }

    void writerAndCleanerLock() {
        this.doLock(3L);
    }

    void writerAndCleanerUnlock() {
        this.doUnlock(3L);
    }

    private void doLock(long targetLockBit) {
        long newState;
        long currentState;
        do {
            currentState = this.state;
            while (!this.canLock(currentState, targetLockBit)) {
                this.sleep();
                currentState = this.state;
            }
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)stateOffset, (long)currentState, (long)(newState = currentState | targetLockBit)));
    }

    private void doUnlock(long targetLockBit) {
        long newState;
        long currentState;
        do {
            if (this.canUnlock(currentState = this.state, targetLockBit)) continue;
            throw new IllegalStateException("Can not unlock lock that is already locked");
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)stateOffset, (long)currentState, (long)(newState = currentState & (targetLockBit ^ 0xFFFFFFFFFFFFFFFFL))));
    }

    private boolean canLock(long state, long targetLockBit) {
        return (state & targetLockBit) == 0L;
    }

    private boolean canUnlock(long state, long targetLockBit) {
        return (state & targetLockBit) == targetLockBit;
    }

    private void sleep() {
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
    }

    @VisibleForTesting
    void forceUnlock() {
        this.state = 0L;
    }
}

