/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeStructure;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.LayoutBootstrapper;
import org.neo4j.index.internal.gbptree.Meta;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.scheduler.JobScheduler;

public class GBPTreeBootstrapper {
    private final PageCache pageCache;
    private final LayoutBootstrapper layoutBootstrapper;
    private final boolean readOnly;
    private final PageCacheTracer pageCacheTracer;

    public GBPTreeBootstrapper(PageCache pageCache, LayoutBootstrapper layoutBootstrapper, boolean readOnly, PageCacheTracer pageCacheTracer) {
        this.pageCache = pageCache;
        this.layoutBootstrapper = layoutBootstrapper;
        this.readOnly = readOnly;
        this.pageCacheTracer = pageCacheTracer;
    }

    public Bootstrap bootstrapTree(File file) {
        try {
            MetaVisitor metaVisitor = new MetaVisitor();
            try (PageCursorTracer cursorTracer = this.pageCacheTracer.createPageCursorTracer("TreeBootstrap");){
                GBPTreeStructure.visitHeader(this.pageCache, file, metaVisitor, cursorTracer);
            }
            Meta meta = metaVisitor.meta;
            Pair<TreeState, TreeState> statePair = metaVisitor.statePair;
            TreeState state = TreeStatePair.selectNewestValidState(statePair);
            Layout<?, ?> layout = this.layoutBootstrapper.create(file, this.pageCache, meta);
            GBPTree tree = new GBPTree(this.pageCache, file, layout, meta.getPageSize(), GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, GBPTree.NO_HEADER_WRITER, RecoveryCleanupWorkCollector.ignore(), this.readOnly, this.pageCacheTracer, (ImmutableSet<OpenOption>)Sets.immutable.empty());
            return new SuccessfulBootstrap(tree, layout, state, meta);
        }
        catch (Exception e) {
            return new FailedBootstrap(e);
        }
    }

    public static PageCache pageCache(JobScheduler jobScheduler) {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        SingleFilePageSwapperFactory swapper = new SingleFilePageSwapperFactory((FileSystemAbstraction)fs);
        return new MuninnPageCache((PageSwapperFactory)swapper, 100, PageCacheTracer.NULL, EmptyVersionContextSupplier.EMPTY, jobScheduler);
    }

    private static class MetaVisitor<KEY, VALUE>
    extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
        private Meta meta;
        private Pair<TreeState, TreeState> statePair;

        private MetaVisitor() {
        }

        @Override
        public void meta(Meta meta) {
            this.meta = meta;
        }

        @Override
        public void treeState(Pair<TreeState, TreeState> statePair) {
            this.statePair = statePair;
        }
    }

    private static class SuccessfulBootstrap
    implements Bootstrap {
        private final GBPTree<?, ?> tree;
        private final Layout<?, ?> layout;
        private final TreeState state;
        private final Meta meta;

        SuccessfulBootstrap(GBPTree<?, ?> tree, Layout<?, ?> layout, TreeState state, Meta meta) {
            this.tree = tree;
            this.layout = layout;
            this.state = state;
            this.meta = meta;
        }

        @Override
        public boolean isTree() {
            return true;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            return this.tree;
        }

        @Override
        public Layout<?, ?> getLayout() {
            return this.layout;
        }

        @Override
        public TreeState getState() {
            return this.state;
        }

        @Override
        public Meta getMeta() {
            return this.meta;
        }
    }

    private static class FailedBootstrap
    implements Bootstrap {
        private final Throwable cause;

        FailedBootstrap(Throwable cause) {
            this.cause = cause;
        }

        @Override
        public boolean isTree() {
            return false;
        }

        @Override
        public GBPTree<?, ?> getTree() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public Layout<?, ?> getLayout() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public TreeState getState() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }

        @Override
        public Meta getMeta() {
            throw new IllegalStateException("Bootstrap failed", this.cause);
        }
    }

    public static interface Bootstrap {
        public boolean isTree();

        public GBPTree<?, ?> getTree();

        public Layout<?, ?> getLayout();

        public TreeState getState();

        public Meta getMeta();
    }
}

