/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.impl.factory.primitive.IntObjectMaps;
import org.neo4j.index.internal.gbptree.SeekCursor;

class SizeEstimationMonitor
implements SeekCursor.Monitor {
    private static final int DEPTH_NOT_DECIDED = -1;
    private final MutableIntObjectMap<Stats> depthStats = IntObjectMaps.mutable.empty();
    private int treeDepth = -1;
    private boolean allHaveSameDepth = true;

    SizeEstimationMonitor() {
    }

    @Override
    public void internalNode(int depth, int keyCount) {
        ((Stats)this.depthStats.getIfAbsentPut(depth, (Function0 & Serializable)() -> new Stats())).add(keyCount + 1);
    }

    @Override
    public void leafNode(int depth, int keyCount) {
        ((Stats)this.depthStats.getIfAbsentPut(depth, (Function0 & Serializable)() -> new Stats())).add(keyCount);
        if (this.treeDepth == -1) {
            this.treeDepth = depth;
        } else if (this.treeDepth != depth) {
            this.allHaveSameDepth = false;
        }
    }

    void clear() {
        this.treeDepth = -1;
        this.allHaveSameDepth = true;
        this.depthStats.clear();
    }

    boolean isConsistent() {
        return this.allHaveSameDepth;
    }

    long estimateNumberOfKeys() {
        double count = 1.0;
        for (int i = 0; i <= this.treeDepth; ++i) {
            count *= ((Stats)this.depthStats.get(i)).averageNumberOfKeys();
        }
        return (long)count;
    }

    private static class Stats {
        int numberOfVisitedNodes;
        int numberOfKeys;

        private Stats() {
        }

        void add(int keyCount) {
            ++this.numberOfVisitedNodes;
            this.numberOfKeys += keyCount;
        }

        double averageNumberOfKeys() {
            return (double)this.numberOfKeys / (double)this.numberOfVisitedNodes;
        }
    }
}

