/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.Layout;

class KeyPartitioning<KEY> {
    private final Layout<KEY, ?> layout;

    KeyPartitioning(Layout<KEY, ?> layout) {
        this.layout = layout;
    }

    public List<Pair<KEY, KEY>> partition(List<KEY> keyCandidates, KEY fromInclusive, KEY toExclusive, int numberOfPartitions) {
        float stride;
        List keys = keyCandidates.stream().filter(key -> this.layout.compare(key, fromInclusive) > 0 && this.layout.compare(key, toExclusive) < 0).collect(Collectors.toList());
        ArrayList<Pair<KEY, KEY>> partitions = new ArrayList<Pair<KEY, KEY>>();
        float pos = stride = keys.size() < numberOfPartitions ? 1.0f : (1.0f + (float)keys.size()) / (float)numberOfPartitions;
        KEY prev = fromInclusive;
        int i = 0;
        while (i < numberOfPartitions - 1 && i < keys.size()) {
            Object split = keys.get(Math.round(pos) - 1);
            partitions.add(Pair.of(prev, split));
            prev = this.layout.newKey();
            this.layout.copyKey(split, prev);
            ++i;
            pos += stride;
        }
        partitions.add(Pair.of(prev, toExclusive));
        return partitions;
    }
}

