/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.PrintStream;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.index.internal.gbptree.GBPTreeVisitor;
import org.neo4j.index.internal.gbptree.TreeState;

public class PrintingGBPTreeVisitor<KEY, VALUE>
extends GBPTreeVisitor.Adaptor<KEY, VALUE> {
    private final PrintStream out;
    private final boolean printValues;
    private final boolean printPosition;
    private final boolean printState;
    private final boolean printHeader;

    public PrintingGBPTreeVisitor(PrintStream out, boolean printValues, boolean printPosition, boolean printState, boolean printHeader) {
        this.out = out;
        this.printValues = printValues;
        this.printPosition = printPosition;
        this.printState = printState;
        this.printHeader = printHeader;
    }

    @Override
    public void treeState(Pair<TreeState, TreeState> statePair) {
        if (this.printState) {
            this.out.println("StateA: " + statePair.getLeft());
            this.out.println("StateB: " + statePair.getRight());
        }
    }

    @Override
    public void beginLevel(int level) {
        this.out.println("Level " + level);
    }

    @Override
    public void beginNode(long pageId, boolean isLeaf, long generation, int keyCount) {
        if (this.printHeader) {
            String treeNodeType = isLeaf ? "leaf" : "internal";
            this.out.print(String.format("{%d,%s,generation=%d,keyCount=%d} ", pageId, treeNodeType, generation, keyCount));
        } else {
            this.out.print("{" + pageId + "} ");
        }
    }

    @Override
    public void position(int i) {
        if (this.printPosition) {
            this.out.print("#" + i + " ");
        }
    }

    @Override
    public void key(KEY key, boolean isLeaf) {
        this.out.print(isLeaf ? key : "[" + key + "]");
    }

    @Override
    public void value(VALUE value) {
        if (this.printValues) {
            this.out.print("=" + value);
        }
        this.out.print(" ");
    }

    @Override
    public void child(long child) {
        this.out.print(" /" + child + "\\ ");
    }

    @Override
    public void endNode(long pageId) {
        this.out.println();
    }
}

