/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.function.Supplier;
import org.neo4j.index.internal.gbptree.Root;
import org.neo4j.index.internal.gbptree.RootCatchup;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.util.FeatureToggles;

public class TripCountingRootCatchup
implements RootCatchup {
    static final String MAX_TRIP_COUNT_NAME = "max_trip_count";
    static final int MAX_TRIP_COUNT_DEFAULT = 10;
    private final Supplier<Root> rootSupplier;
    private final int maxTripCount;
    private long lastFromId = 0L;
    private int tripCount;

    TripCountingRootCatchup(Supplier<Root> rootSupplier) {
        this.rootSupplier = rootSupplier;
        this.maxTripCount = FeatureToggles.getInteger(TripCountingRootCatchup.class, (String)MAX_TRIP_COUNT_NAME, (int)10);
    }

    @Override
    public Root catchupFrom(long fromId) {
        this.updateTripCount(fromId);
        this.assertTripCount();
        return this.rootSupplier.get();
    }

    private void updateTripCount(long fromId) {
        if (fromId == this.lastFromId) {
            ++this.tripCount;
        } else {
            this.lastFromId = fromId;
            this.tripCount = 1;
        }
    }

    private void assertTripCount() {
        if (this.tripCount >= this.maxTripCount) {
            throw new TreeInconsistencyException("Index traversal aborted due to being stuck in infinite loop. This is most likely caused by an inconsistency in the index. Loop occurred when restarting search from root from page %d.", this.lastFromId);
        }
    }
}

