/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.StringJoiner;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class GroupingRecoveryCleanupWorkCollector
extends RecoveryCleanupWorkCollector {
    private final BlockingQueue<CleanupJob> jobs = new LinkedBlockingQueue<CleanupJob>();
    private final JobScheduler jobScheduler;
    private volatile boolean started;
    private JobHandle handle;

    public GroupingRecoveryCleanupWorkCollector(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public void init() {
        this.started = false;
        if (!this.jobs.isEmpty()) {
            StringJoiner joiner = new StringJoiner(String.format("%n  ", new Object[0]), "Did not expect there to be any cleanup jobs still here. Jobs[", "]");
            this.consumeAndCloseJobs(cj -> joiner.add(cj.toString()));
            throw new IllegalStateException(joiner.toString());
        }
        this.scheduleJobs();
    }

    @Override
    public void add(CleanupJob job) {
        if (this.started) {
            throw new IllegalStateException("Index clean jobs can't be added after collector start.");
        }
        this.jobs.add(job);
    }

    public void start() {
        this.started = true;
    }

    public void shutdown() throws ExecutionException, InterruptedException {
        this.started = true;
        if (this.handle != null) {
            this.handle.waitTermination();
        }
        this.consumeAndCloseJobs(cj -> {});
    }

    private void scheduleJobs() {
        this.handle = this.jobScheduler.schedule(Group.STORAGE_MAINTENANCE, this.allJobs());
    }

    private Runnable allJobs() {
        return () -> this.executeWithExecutor(executor -> {
            CleanupJob job = null;
            do {
                try {
                    job = this.jobs.poll(100L, TimeUnit.MILLISECONDS);
                    if (job == null) continue;
                    job.run(executor);
                }
                catch (Exception exception) {
                }
                finally {
                    if (job != null) {
                        job.close();
                    }
                }
            } while (!this.jobs.isEmpty() || !this.started);
        });
    }

    private void consumeAndCloseJobs(Consumer<CleanupJob> consumer) {
        CleanupJob job;
        while ((job = (CleanupJob)this.jobs.poll()) != null) {
            consumer.accept(job);
            job.close();
        }
    }
}

