/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import java.util.StringJoiner;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GBPTreeLock;

class GBPTreeCleanupJob
implements CleanupJob {
    private final CrashGenerationCleaner crashGenerationCleaner;
    private final GBPTreeLock gbpTreeLock;
    private final GBPTree.Monitor monitor;
    private final File indexFile;
    private volatile boolean needed;
    private volatile Throwable failure;

    GBPTreeCleanupJob(CrashGenerationCleaner crashGenerationCleaner, GBPTreeLock gbpTreeLock, GBPTree.Monitor monitor, File indexFile) {
        this.crashGenerationCleaner = crashGenerationCleaner;
        this.gbpTreeLock = gbpTreeLock;
        this.monitor = monitor;
        this.indexFile = indexFile;
        this.needed = true;
    }

    @Override
    public boolean needed() {
        return this.needed;
    }

    @Override
    public boolean hasFailed() {
        return this.failure != null;
    }

    @Override
    public Throwable getCause() {
        return this.failure;
    }

    @Override
    public void close() {
        this.gbpTreeLock.cleanerUnlock();
        this.monitor.cleanupClosed();
    }

    @Override
    public void run() {
        try {
            this.crashGenerationCleaner.clean();
            this.needed = false;
        }
        catch (Throwable e) {
            this.monitor.cleanupFailed(e);
            this.failure = e;
        }
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "CleanupJob(", ")");
        joiner.add("file=" + this.indexFile.getAbsolutePath());
        joiner.add("needed=" + this.needed);
        joiner.add("failure=" + (this.failure == null ? null : this.failure.toString()));
        return joiner.toString();
    }
}

