/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.index.internal.gbptree.ConsistencyChecker;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.index.internal.gbptree.TreeState;
import org.neo4j.index.internal.gbptree.TreeStatePair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;

public class TreePrinter<KEY, VALUE> {
    private final TreeNode<KEY, VALUE> node;
    private final Layout<KEY, VALUE> layout;
    private final long stableGeneration;
    private final long unstableGeneration;

    TreePrinter(TreeNode<KEY, VALUE> node, Layout<KEY, VALUE> layout, long stableGeneration, long unstableGeneration) {
        this.node = node;
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    public static void printHeader(FileSystemAbstraction fs, File file, PrintStream out) throws IOException {
        SingleFilePageSwapperFactory swapper = new SingleFilePageSwapperFactory();
        swapper.open(fs, Configuration.EMPTY);
        PageCursorTracerSupplier cursorTracerSupplier = PageCursorTracerSupplier.NULL;
        try (MuninnPageCache pageCache = new MuninnPageCache((PageSwapperFactory)swapper, 100, PageCacheTracer.NULL, cursorTracerSupplier, EmptyVersionContextSupplier.EMPTY);){
            TreePrinter.printHeader((PageCache)pageCache, file, out);
        }
    }

    private static void printHeader(PageCache pageCache, File file, PrintStream out) throws IOException {
        try (PagedFile pagedFile = pageCache.map(file, pageCache.pageSize(), new OpenOption[]{StandardOpenOption.READ});
             PageCursor cursor = pagedFile.io(1L, 1);){
            TreePrinter.printTreeState(cursor, out);
        }
    }

    static void printTreeState(PageCursor cursor, PrintStream out) throws IOException {
        Pair<TreeState, TreeState> statePair = TreeStatePair.readStatePages(cursor, 1L, 2L);
        out.println("StateA: " + statePair.getLeft());
        out.println("StateB: " + statePair.getRight());
    }

    void printTree(PageCursor cursor, PageCursor writeCursor, PrintStream out, boolean printValues, boolean printPosition, boolean printState, boolean printHeader) throws IOException {
        if (printState) {
            long currentPage = cursor.getCurrentPageId();
            TreePrinter.printTreeState(cursor, out);
            TreeNode.goTo(cursor, "back to tree node from reading state", currentPage);
        }
        ConsistencyChecker.assertOnTreeNode(TreePrinter.select(cursor, writeCursor));
        int level = 0;
        do {
            out.println("Level " + level++);
            long leftmostSibling = cursor.getCurrentPageId();
            this.printLevel(cursor, writeCursor, out, printValues, printPosition, printHeader);
            TreeNode.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor, writeCursor));
    }

    void printTreeNode(PageCursor cursor, PrintStream out, boolean printValues, boolean printPosition, boolean printHeader) throws IOException {
        int keyCount;
        boolean isLeaf;
        do {
            isLeaf = TreeNode.isLeaf(cursor);
            keyCount = TreeNode.keyCount(cursor);
            if (this.node.reasonableKeyCount(keyCount)) continue;
            cursor.setCursorException("Unexpected keyCount " + keyCount);
        } while (cursor.shouldRetry());
        if (printHeader) {
            long generation = -1L;
            do {
                generation = TreeNode.generation(cursor);
            } while (cursor.shouldRetry());
            String treeNodeType = isLeaf ? "leaf" : "internal";
            out.print(String.format("{%d,%s,generation=%d,keyCount=%d}", cursor.getCurrentPageId(), treeNodeType, generation, keyCount));
        } else {
            out.print("{" + cursor.getCurrentPageId() + "} ");
        }
        KEY key = this.layout.newKey();
        VALUE value = this.layout.newValue();
        for (int i = 0; i < keyCount; ++i) {
            long child = -1L;
            do {
                this.node.keyAt(cursor, key, i, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL);
                if (isLeaf) {
                    this.node.valueAt(cursor, value, i);
                    continue;
                }
                child = GenerationSafePointerPair.pointer(this.node.childAt(cursor, i, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            if (printPosition) {
                out.print("#" + i + " ");
            }
            if (isLeaf) {
                out.print(key);
                if (printValues) {
                    out.print("=" + value);
                }
            } else {
                out.print("/" + child + "\\ [" + key + "]");
            }
            out.print(" ");
        }
        if (!isLeaf) {
            long child;
            do {
                child = GenerationSafePointerPair.pointer(this.node.childAt(cursor, keyCount, this.stableGeneration, this.unstableGeneration));
            } while (cursor.shouldRetry());
            if (printPosition) {
                out.print("#" + keyCount + " ");
            }
            out.print("/" + child + "\\");
        }
        out.println();
    }

    private boolean goToLeftmostChild(PageCursor readCursor, PageCursor writeCursor) throws IOException {
        boolean isInternal;
        long leftmostSibling = -1L;
        PageCursor cursor = TreePrinter.select(readCursor, writeCursor);
        do {
            if (!(isInternal = TreeNode.isInternal(cursor))) continue;
            leftmostSibling = this.node.childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
        } while (cursor.shouldRetry());
        if (isInternal) {
            TreeNode.goTo(readCursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private void printLevel(PageCursor readCursor, PageCursor writeCursor, PrintStream out, boolean printValues, boolean printPosition, boolean printHeader) throws IOException {
        long rightSibling = -1L;
        do {
            PageCursor cursor = TreePrinter.select(readCursor, writeCursor);
            this.printTreeNode(cursor, out, printValues, printPosition, printHeader);
            do {
                rightSibling = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            } while (cursor.shouldRetry());
            if (!TreeNode.isNode(rightSibling)) continue;
            TreeNode.goTo(readCursor, "right sibling", rightSibling);
        } while (TreeNode.isNode(rightSibling));
    }

    private static PageCursor select(PageCursor readCursor, PageCursor writeCursor) {
        return writeCursor == null ? readCursor : (readCursor.getCurrentPageId() == writeCursor.getCurrentPageId() ? writeCursor : readCursor);
    }
}

