/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.scheduler.JobScheduler;

public class GroupingRecoveryCleanupWorkCollector
extends LifecycleAdapter
implements RecoveryCleanupWorkCollector {
    private final Queue<CleanupJob> jobs;
    private final JobScheduler jobScheduler;
    private volatile boolean started;

    public GroupingRecoveryCleanupWorkCollector(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.jobs = new LinkedBlockingQueue<CleanupJob>();
    }

    public void init() {
        this.started = false;
        this.jobs.clear();
    }

    @Override
    public void add(CleanupJob job) {
        if (this.started) {
            throw new IllegalStateException("Index clean jobs can't be added after collector start.");
        }
        this.jobs.add(job);
    }

    public void start() {
        this.scheduleJobs();
        this.started = true;
    }

    private void scheduleJobs() {
        this.jobScheduler.schedule(JobScheduler.Groups.recoveryCleanup, this.allJobs());
    }

    private Runnable allJobs() {
        return () -> {
            CleanupJob job;
            Exception jobsException = null;
            while ((job = this.jobs.poll()) != null) {
                try {
                    job.run();
                }
                catch (Exception e) {
                    if (jobsException == null) {
                        jobsException = e;
                        continue;
                    }
                    jobsException.addSuppressed(e);
                }
                finally {
                    job.close();
                }
            }
            if (jobsException != null) {
                throw new RuntimeException(jobsException);
            }
        };
    }
}

