/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.RightmostInChain;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;

class ConsistencyChecker<KEY> {
    private final TreeNode<KEY, ?> node;
    private final KEY readKey;
    private final Comparator<KEY> comparator;
    private final Layout<KEY, ?> layout;
    private final List<RightmostInChain> rightmostPerLevel = new ArrayList<RightmostInChain>();
    private final long stableGeneration;
    private final long unstableGeneration;

    ConsistencyChecker(TreeNode<KEY, ?> node, Layout<KEY, ?> layout, long stableGeneration, long unstableGeneration) {
        this.node = node;
        this.readKey = layout.newKey();
        this.comparator = node.keyComparator();
        this.layout = layout;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
    }

    public boolean check(PageCursor cursor, long expectedGeneration) throws IOException {
        ConsistencyChecker.assertOnTreeNode(cursor);
        KeyRange openRange = new KeyRange(this.comparator, null, null, this.layout, null);
        boolean result = this.checkSubtree(cursor, openRange, expectedGeneration, 0);
        this.rightmostPerLevel.forEach(RightmostInChain::assertLast);
        return result;
    }

    boolean checkSpace(PageCursor cursor, long lastId, LongIterator freelistIds) throws IOException {
        ConsistencyChecker.assertOnTreeNode(cursor);
        long highId = lastId + 1L;
        BitSet seenIds = new BitSet(Math.toIntExact(highId));
        while (freelistIds.hasNext()) {
            ConsistencyChecker.addToSeenList(seenIds, freelistIds.next(), lastId);
        }
        do {
            long leftmostSibling = cursor.getCurrentPageId();
            ConsistencyChecker.addToSeenList(seenIds, leftmostSibling, lastId);
            this.traverseAndAddRightSiblings(cursor, seenIds, lastId);
            TreeNode.goTo(cursor, "back", leftmostSibling);
        } while (this.goToLeftmostChild(cursor));
        ConsistencyChecker.assertAllIdsOccupied(highId, seenIds);
        return true;
    }

    private boolean goToLeftmostChild(PageCursor cursor) throws IOException {
        boolean isInternal;
        long leftmostSibling = -1L;
        do {
            if (!(isInternal = TreeNode.isInternal(cursor))) continue;
            leftmostSibling = this.node.childAt(cursor, 0, this.stableGeneration, this.unstableGeneration);
        } while (cursor.shouldRetry());
        if (isInternal) {
            TreeNode.goTo(cursor, "child", leftmostSibling);
        }
        return isInternal;
    }

    private static void assertAllIdsOccupied(long highId, BitSet seenIds) {
        long expectedNumberOfPages = highId - 3L;
        if ((long)seenIds.cardinality() != expectedNumberOfPages) {
            StringBuilder builder = new StringBuilder("[");
            int index = 3;
            int count = 0;
            while (index >= 0 && (long)index < highId) {
                if ((index = seenIds.nextClearBit(index)) == -1) continue;
                if (count++ > 0) {
                    builder.append(",");
                }
                builder.append(index);
                ++index;
            }
            builder.append("]");
            throw new RuntimeException("There are " + count + " unused pages in the store:" + builder);
        }
    }

    private void traverseAndAddRightSiblings(PageCursor cursor, BitSet seenIds, long lastId) throws IOException {
        while (true) {
            long rightSibling = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            if (cursor.shouldRetry()) continue;
            if (TreeNode.isNode(rightSibling)) {
                TreeNode.goTo(cursor, "right sibling", rightSibling);
                ConsistencyChecker.addToSeenList(seenIds, GenerationSafePointerPair.pointer(rightSibling), lastId);
            }
            if (!TreeNode.isNode(rightSibling)) break;
        }
    }

    private static void addToSeenList(BitSet target, long id, long lastId) {
        int index = Math.toIntExact(id);
        if (target.get(index)) {
            throw new IllegalStateException(id + " already seen");
        }
        if (id > lastId) {
            throw new IllegalStateException("Unexpectedly high id " + id + " seen when last id is " + lastId);
        }
        target.set(index);
    }

    static void assertOnTreeNode(PageCursor cursor) throws IOException {
        boolean isLeaf;
        boolean isInternal;
        byte nodeType;
        do {
            nodeType = TreeNode.nodeType(cursor);
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        if (nodeType != 1) {
            throw new IllegalArgumentException("Cursor is not pinned to a tree node page. pageId:" + cursor.getCurrentPageId());
        }
        if (!isInternal && !isLeaf) {
            throw new IllegalArgumentException("Cursor is not pinned to a page containing a tree node. pageId:" + cursor.getCurrentPageId());
        }
    }

    private boolean checkSubtree(PageCursor cursor, KeyRange<KEY> range, long expectedGeneration, int level) throws IOException {
        int keyCount;
        long successorGeneration;
        long successor;
        long currentNodeGeneration;
        long rightSiblingPointerGeneration;
        long leftSiblingPointerGeneration;
        long rightSiblingPointer;
        long leftSiblingPointer;
        boolean isInternal = false;
        boolean isLeaf = false;
        do {
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "LeftSibling", 34);
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "RightSibling", 10);
            ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "Successor", 58);
            leftSiblingPointer = TreeNode.leftSibling(cursor, this.stableGeneration, this.unstableGeneration);
            rightSiblingPointer = TreeNode.rightSibling(cursor, this.stableGeneration, this.unstableGeneration);
            leftSiblingPointerGeneration = this.node.pointerGeneration(cursor, leftSiblingPointer);
            rightSiblingPointerGeneration = this.node.pointerGeneration(cursor, rightSiblingPointer);
            leftSiblingPointer = GenerationSafePointerPair.pointer(leftSiblingPointer);
            rightSiblingPointer = GenerationSafePointerPair.pointer(rightSiblingPointer);
            currentNodeGeneration = TreeNode.generation(cursor);
            successor = TreeNode.successor(cursor, this.stableGeneration, this.unstableGeneration);
            successorGeneration = this.node.pointerGeneration(cursor, successor);
            keyCount = TreeNode.keyCount(cursor);
            if (!this.node.reasonableKeyCount(keyCount)) {
                cursor.setCursorException("Unexpected keyCount:" + keyCount);
                continue;
            }
            isInternal = TreeNode.isInternal(cursor);
            isLeaf = TreeNode.isLeaf(cursor);
        } while (cursor.shouldRetry());
        ConsistencyChecker.checkAfterShouldRetry(cursor);
        if (!isInternal && !isLeaf) {
            throw new TreeInconsistencyException("Page:" + cursor.getCurrentPageId() + " at level:" + level + " isn't a tree node, parent expected range " + range, new Object[0]);
        }
        do {
            this.assertKeyOrder(cursor, range, keyCount, isLeaf ? TreeNode.Type.LEAF : TreeNode.Type.INTERNAL);
        } while (cursor.shouldRetry());
        ConsistencyChecker.assertPointerGenerationMatchesGeneration(cursor, currentNodeGeneration, expectedGeneration);
        this.assertSiblings(cursor, currentNodeGeneration, leftSiblingPointer, leftSiblingPointerGeneration, rightSiblingPointer, rightSiblingPointerGeneration, level);
        this.checkSuccessorPointerGeneration(cursor, successor, successorGeneration);
        if (isInternal) {
            this.assertSubtrees(cursor, range, keyCount, level);
        }
        return true;
    }

    private static void assertPointerGenerationMatchesGeneration(PageCursor cursor, long nodeGeneration, long expectedGeneration) {
        assert (nodeGeneration <= expectedGeneration) : "Expected node:" + cursor.getCurrentPageId() + " generation:" + nodeGeneration + " to be \u2264 pointer generation:" + expectedGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSuccessorPointerGeneration(PageCursor cursor, long successor, long successorGeneration) throws IOException {
        if (TreeNode.isNode(successor)) {
            cursor.setCursorException("WARNING: we ended up on an old generation " + cursor.getCurrentPageId() + " which had successor:" + GenerationSafePointerPair.pointer(successor));
            long origin = cursor.getCurrentPageId();
            TreeNode.goTo(cursor, "successor", successor);
            try {
                long nodeGeneration;
                do {
                    nodeGeneration = TreeNode.generation(cursor);
                } while (cursor.shouldRetry());
                ConsistencyChecker.assertPointerGenerationMatchesGeneration(cursor, nodeGeneration, successorGeneration);
            }
            finally {
                TreeNode.goTo(cursor, "back", origin);
            }
        }
    }

    private void assertSiblings(PageCursor cursor, long currentNodeGeneration, long leftSiblingPointer, long leftSiblingPointerGeneration, long rightSiblingPointer, long rightSiblingPointerGeneration, int level) {
        for (int i = this.rightmostPerLevel.size(); i <= level; ++i) {
            this.rightmostPerLevel.add(i, new RightmostInChain());
        }
        RightmostInChain rightmost = this.rightmostPerLevel.get(level);
        rightmost.assertNext(cursor, currentNodeGeneration, leftSiblingPointer, leftSiblingPointerGeneration, rightSiblingPointer, rightSiblingPointerGeneration);
    }

    private void assertSubtrees(PageCursor cursor, KeyRange<KEY> range, int keyCount, int level) throws IOException {
        KeyRange<Object> childRange;
        long childGeneration;
        long child;
        int pos;
        long pageId = cursor.getCurrentPageId();
        Object prev = null;
        for (pos = 0; pos < keyCount; ++pos) {
            do {
                child = this.childAt(cursor, pos);
                childGeneration = this.node.pointerGeneration(cursor, child);
                this.node.keyAt(cursor, this.readKey, pos, TreeNode.Type.INTERNAL);
            } while (cursor.shouldRetry());
            ConsistencyChecker.checkAfterShouldRetry(cursor);
            childRange = range.restrictRight(this.readKey);
            if (pos > 0) {
                childRange = range.restrictLeft(prev);
            }
            TreeNode.goTo(cursor, "child at pos " + pos, child);
            this.checkSubtree(cursor, childRange, childGeneration, level + 1);
            TreeNode.goTo(cursor, "parent", pageId);
            if (pos == 0) {
                prev = this.layout.newKey();
            }
            this.layout.copyKey(this.readKey, prev);
        }
        do {
            child = this.childAt(cursor, pos);
        } while (cursor.shouldRetry());
        ConsistencyChecker.checkAfterShouldRetry(cursor);
        do {
            childGeneration = this.node.pointerGeneration(cursor, child);
        } while (cursor.shouldRetry());
        ConsistencyChecker.checkAfterShouldRetry(cursor);
        TreeNode.goTo(cursor, "child at pos " + pos, child);
        childRange = range.restrictLeft(prev);
        this.checkSubtree(cursor, childRange, childGeneration, level + 1);
        TreeNode.goTo(cursor, "parent", pageId);
    }

    private static void checkAfterShouldRetry(PageCursor cursor) throws CursorException {
        PageCursorUtil.checkOutOfBounds(cursor);
        cursor.checkAndClearCursorException();
    }

    private long childAt(PageCursor cursor, int pos) {
        ConsistencyChecker.assertNoCrashOrBrokenPointerInGSPP(cursor, this.stableGeneration, this.unstableGeneration, "Child", this.node.childOffset(pos));
        return this.node.childAt(cursor, pos, this.stableGeneration, this.unstableGeneration);
    }

    private void assertKeyOrder(PageCursor cursor, KeyRange<KEY> range, int keyCount, TreeNode.Type type) {
        KEY prev = this.layout.newKey();
        boolean first = true;
        for (int pos = 0; pos < keyCount; ++pos) {
            this.node.keyAt(cursor, this.readKey, pos, type);
            if (!range.inRange(this.readKey)) {
                cursor.setCursorException(String.format("Expected range for this node is %n%s%n but found %s in position %d, with keyCount %d on page %d", range, this.readKey, pos, keyCount, cursor.getCurrentPageId()));
            }
            if (!first) {
                if (this.comparator.compare(prev, this.readKey) >= 0) {
                    cursor.setCursorException("Non-unique key " + this.readKey);
                }
            } else {
                first = false;
            }
            this.layout.copyKey(this.readKey, prev);
        }
    }

    static void assertNoCrashOrBrokenPointerInGSPP(PageCursor cursor, long stableGeneration, long unstableGeneration, String pointerFieldName, int offset) {
        boolean okB;
        cursor.setOffset(offset);
        long currentNodeId = cursor.getCurrentPageId();
        long generationA = GenerationSafePointer.readGeneration(cursor);
        long readPointerA = GenerationSafePointer.readPointer(cursor);
        long pointerA = GenerationSafePointerPair.pointer(readPointerA);
        short checksumA = GenerationSafePointer.readChecksum(cursor);
        boolean correctChecksumA = GenerationSafePointer.checksumOf(generationA, readPointerA) == checksumA;
        byte stateA = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationA, readPointerA, correctChecksumA);
        boolean okA = stateA != 3 && stateA != 2;
        long generationB = GenerationSafePointer.readGeneration(cursor);
        long readPointerB = GenerationSafePointer.readPointer(cursor);
        long pointerB = GenerationSafePointerPair.pointer(readPointerA);
        short checksumB = GenerationSafePointer.readChecksum(cursor);
        boolean correctChecksumB = GenerationSafePointer.checksumOf(generationB, readPointerB) == checksumB;
        byte stateB = GenerationSafePointerPair.pointerState(stableGeneration, unstableGeneration, generationB, readPointerB, correctChecksumB);
        boolean bl = okB = stateB != 3 && stateB != 2;
        if (!okA || !okB) {
            boolean isInternal = TreeNode.isInternal(cursor);
            String type = isInternal ? "internal" : "leaf";
            cursor.setCursorException(String.format("GSPP state found that was not ok in %s field in %s node with id %d%n  slotA[%s]%n  slotB[%s]", pointerFieldName, type, currentNodeId, ConsistencyChecker.stateToString(generationA, readPointerA, pointerA, stateA), ConsistencyChecker.stateToString(generationB, readPointerB, pointerB, stateB)));
        }
    }

    private static String stateToString(long generation, long readPointer, long pointer, byte stateA) {
        return String.format("generation=%d, readPointer=%d, pointer=%d, state=%s", generation, readPointer, pointer, GenerationSafePointerPair.pointerStateName(stateA));
    }

    private static class KeyRange<KEY> {
        private final Comparator<KEY> comparator;
        private final KEY fromInclusive;
        private final KEY toExclusive;
        private final Layout<KEY, ?> layout;
        private final KeyRange<KEY> superRange;

        private KeyRange(Comparator<KEY> comparator, KEY fromInclusive, KEY toExclusive, Layout<KEY, ?> layout, KeyRange<KEY> superRange) {
            this.comparator = comparator;
            this.superRange = superRange;
            this.fromInclusive = fromInclusive == null ? null : layout.copyKey(fromInclusive, layout.newKey());
            this.toExclusive = toExclusive == null ? null : layout.copyKey(toExclusive, layout.newKey());
            this.layout = layout;
        }

        boolean inRange(KEY key) {
            if (this.fromInclusive != null) {
                if (this.toExclusive != null) {
                    return this.comparator.compare(key, this.fromInclusive) >= 0 && this.comparator.compare(key, this.toExclusive) < 0;
                }
                return this.comparator.compare(key, this.fromInclusive) >= 0;
            }
            return this.toExclusive == null || this.comparator.compare(key, this.toExclusive) < 0;
        }

        KeyRange<KEY> restrictLeft(KEY left) {
            if (this.fromInclusive == null) {
                return new KeyRange<KEY>(this.comparator, left, this.toExclusive, this.layout, this);
            }
            if (left == null) {
                return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
            }
            if (this.comparator.compare(this.fromInclusive, left) < 0) {
                return new KeyRange<KEY>(this.comparator, left, this.toExclusive, this.layout, this);
            }
            return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
        }

        KeyRange<KEY> restrictRight(KEY right) {
            if (this.toExclusive == null) {
                return new KeyRange<KEY>(this.comparator, this.fromInclusive, right, this.layout, this);
            }
            if (right == null) {
                return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
            }
            if (this.comparator.compare(this.toExclusive, right) > 0) {
                return new KeyRange<KEY>(this.comparator, this.fromInclusive, right, this.layout, this);
            }
            return new KeyRange<KEY>(this.comparator, this.fromInclusive, this.toExclusive, this.layout, this);
        }

        public String toString() {
            return (this.superRange != null ? String.format("%s%n", this.superRange) : "") + this.fromInclusive + " \u2264 key < " + this.toExclusive;
        }
    }
}

