/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.io.pagecache.PageCursor;

class DynamicSizeUtil {
    static final int SIZE_OFFSET = 2;
    static final int SIZE_KEY_SIZE = 2;
    static final int SIZE_VALUE_SIZE = 2;
    static final int SIZE_TOTAL_OVERHEAD = 6;
    private static final int FLAG_TOMBSTONE = 32768;

    DynamicSizeUtil() {
    }

    static void putKeyOffset(PageCursor cursor, int keyOffset) {
        PageCursorUtil.putUnsignedShort(cursor, keyOffset);
    }

    static int readKeyOffset(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor);
    }

    static void putKeySize(PageCursor cursor, int keySize) {
        PageCursorUtil.putUnsignedShort(cursor, keySize);
    }

    static void putValueSize(PageCursor cursor, int valueSize) {
        PageCursorUtil.putUnsignedShort(cursor, valueSize);
    }

    static int readKeySize(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor);
    }

    static int readValueSize(PageCursor cursor) {
        return PageCursorUtil.getUnsignedShort(cursor);
    }

    static void putTombstone(PageCursor cursor) {
        int offset = cursor.getOffset();
        int keySize = DynamicSizeUtil.readKeySize(cursor);
        keySize = DynamicSizeUtil.withTombstoneFlag(keySize);
        cursor.setOffset(offset);
        DynamicSizeUtil.putKeySize(cursor, keySize);
    }

    static boolean hasTombstone(int readKeySize) {
        return (readKeySize & 0x8000) != 0;
    }

    static int stripTombstone(int keySize) {
        return keySize & 0xFFFF7FFF;
    }

    private static int withTombstoneFlag(int keySize) {
        assert ((keySize & 0x8000) == 0) : "Key size " + keySize + " is to large to fit tombstone.";
        return keySize | 0x8000;
    }
}

