/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

class CrashGenerationCleaner {
    private final PagedFile pagedFile;
    private final TreeNode<?, ?> treeNode;
    private final long lowTreeNodeId;
    private final long highTreeNodeId;
    private final int availableProcessors;
    private final long batchSize;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final GBPTree.Monitor monitor;

    CrashGenerationCleaner(PagedFile pagedFile, TreeNode<?, ?> treeNode, long lowTreeNodeId, long highTreeNodeId, long stableGeneration, long unstableGeneration, GBPTree.Monitor monitor) {
        this.pagedFile = pagedFile;
        this.treeNode = treeNode;
        this.lowTreeNodeId = lowTreeNodeId;
        this.highTreeNodeId = highTreeNodeId;
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.batchSize = Math.min(1000L, Math.max(10L, (highTreeNodeId - lowTreeNodeId) / (long)(100 * this.availableProcessors)));
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.monitor = monitor;
    }

    public void clean() throws IOException {
        assert (this.unstableGeneration > this.stableGeneration);
        assert (this.unstableGeneration - this.stableGeneration > 1L);
        long startTime = System.currentTimeMillis();
        int threads = this.availableProcessors;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        AtomicLong nextId = new AtomicLong(this.lowTreeNodeId);
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        AtomicInteger cleanedPointers = new AtomicInteger();
        for (int i = 0; i < threads; ++i) {
            executor.submit(this.cleaner(nextId, error, cleanedPointers));
        }
        executor.shutdown();
        try {
            long lastProgression = nextId.get();
            while (!executor.awaitTermination(30L, TimeUnit.SECONDS)) {
                if (lastProgression == nextId.get()) {
                    error.compareAndSet(null, new IOException("No progress, so forcing abort"));
                }
                lastProgression = nextId.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Throwable finalError = error.get();
        if (finalError != null) {
            throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)finalError);
        }
        long endTime = System.currentTimeMillis();
        this.monitor.cleanupFinished(this.highTreeNodeId - this.lowTreeNodeId, cleanedPointers.get(), endTime - startTime);
    }

    private Runnable cleaner(AtomicLong nextId, AtomicReference<Throwable> error, AtomicInteger cleanedPointers) {
        return () -> {
            try (PageCursor cursor = this.pagedFile.io(0L, 1);
                 PageCursor writeCursor = this.pagedFile.io(0L, 2);){
                long localNextId;
                while ((localNextId = nextId.getAndAdd(this.batchSize)) < this.highTreeNodeId) {
                    int i = 0;
                    while ((long)i < this.batchSize && localNextId < this.highTreeNodeId) {
                        PageCursorUtil.goTo(cursor, "clean", localNextId);
                        if (this.hasCrashedGSPP(this.treeNode, cursor)) {
                            writeCursor.next(cursor.getCurrentPageId());
                            this.cleanTreeNode(this.treeNode, writeCursor, cleanedPointers);
                        }
                        ++i;
                        ++localNextId;
                    }
                    if (error.get() == null) continue;
                    break;
                }
            }
            catch (Throwable e) {
                error.compareAndSet(null, e);
            }
        };
    }

    private boolean hasCrashedGSPP(TreeNode<?, ?> treeNode, PageCursor cursor) throws IOException {
        boolean hasCrashed;
        int keyCount;
        boolean isTreeNode;
        do {
            isTreeNode = TreeNode.nodeType(cursor) == 1;
            keyCount = TreeNode.keyCount(cursor);
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        if (!isTreeNode) {
            return false;
        }
        do {
            boolean bl = hasCrashed = this.hasCrashedGSPP(cursor, 58) || this.hasCrashedGSPP(cursor, 34) || this.hasCrashedGSPP(cursor, 10);
            if (hasCrashed || !TreeNode.isInternal(cursor)) continue;
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i) && !hasCrashed; ++i) {
                hasCrashed = this.hasCrashedGSPP(cursor, treeNode.childOffset(i));
            }
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return hasCrashed;
    }

    private boolean hasCrashedGSPP(PageCursor cursor, int gsppOffset) {
        return this.hasCrashedGSP(cursor, gsppOffset) || this.hasCrashedGSP(cursor, gsppOffset + 12);
    }

    private boolean hasCrashedGSP(PageCursor cursor, int offset) {
        cursor.setOffset(offset);
        long generation = GenerationSafePointer.readGeneration(cursor);
        return generation > this.stableGeneration && generation < this.unstableGeneration;
    }

    private void cleanTreeNode(TreeNode<?, ?> treeNode, PageCursor cursor, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSPP(cursor, 58, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 34, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 10, cleanedPointers);
        if (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            for (int i = 0; i <= keyCount && treeNode.reasonableChildCount(i); ++i) {
                this.cleanCrashedGSPP(cursor, treeNode.childOffset(i), cleanedPointers);
            }
        }
    }

    private void cleanCrashedGSPP(PageCursor cursor, int gsppOffset, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSP(cursor, gsppOffset, cleanedPointers);
        this.cleanCrashedGSP(cursor, gsppOffset + 12, cleanedPointers);
    }

    private void cleanCrashedGSP(PageCursor cursor, int gspOffset, AtomicInteger cleanedPointers) {
        if (this.hasCrashedGSP(cursor, gspOffset)) {
            cursor.setOffset(gspOffset);
            GenerationSafePointer.clean(cursor);
            cleanedPointers.incrementAndGet();
        }
    }
}

