/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Comparator;
import org.neo4j.io.pagecache.PageCursor;

public interface Layout<KEY, VALUE>
extends Comparator<KEY> {
    public KEY newKey();

    public KEY copyKey(KEY var1, KEY var2);

    public VALUE newValue();

    public int keySize();

    public int valueSize();

    public void writeKey(PageCursor var1, KEY var2);

    public void writeValue(PageCursor var1, VALUE var2);

    public void readKey(PageCursor var1, KEY var2);

    public void readValue(PageCursor var1, VALUE var2);

    public long identifier();

    public int majorVersion();

    public int minorVersion();

    default public void writeMetaData(PageCursor cursor) {
    }

    default public void readMetaData(PageCursor cursor) {
    }

    public static long namedIdentifier(String name, int identifier) {
        char[] chars = name.toCharArray();
        if (chars.length > 4) {
            throw new IllegalArgumentException("Maximum 4 character name, was '" + name + "'");
        }
        long upperInt = 0L;
        for (char aChar : chars) {
            byte byteValue = (byte)((byte)aChar ^ (byte)(aChar >> 8));
            upperInt <<= 8;
            upperInt |= (long)(byteValue & 0xFF);
        }
        return upperInt << 32 | (long)identifier;
    }

    public boolean compatibleWith(long var1, int var3, int var4);

    public static abstract class ReadOnlyMetaLayout
    implements Layout {
        public Object newKey() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public Object copyKey(Object key, Object into) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public Object newValue() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public int keySize() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public int valueSize() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public void writeKey(PageCursor cursor, Object key) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public void writeValue(PageCursor cursor, Object value) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public void readKey(PageCursor cursor, Object into) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        public void readValue(PageCursor cursor, Object into) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public long identifier() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public int majorVersion() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public int minorVersion() {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }

        @Override
        public int compare(Object o1, Object o2) {
            throw new UnsupportedOperationException("Not allowed with read only layout");
        }
    }

    public static abstract class Adapter<KEY, VALUE>
    implements Layout<KEY, VALUE> {
        public String toString() {
            return String.format("%s[version:%d.%d, identifier:%d, keySize:%d, valueSize:%d]", this.getClass().getSimpleName(), this.majorVersion(), this.minorVersion(), this.identifier(), this.keySize(), this.valueSize());
        }

        @Override
        public boolean compatibleWith(long layoutIdentifier, int majorVersion, int minorVersion) {
            return layoutIdentifier == this.identifier() && majorVersion == this.majorVersion() && minorVersion == this.minorVersion();
        }
    }
}

