/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.scheduler.JobScheduler;

public class GroupingRecoveryCleanupWorkCollector
extends RecoveryCleanupWorkCollector {
    private final Queue<CleanupJob> jobs;
    private final JobScheduler jobScheduler;

    public GroupingRecoveryCleanupWorkCollector(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.jobs = new LinkedBlockingQueue<CleanupJob>();
    }

    public void init() throws Throwable {
        if (!this.jobs.isEmpty()) {
            StringJoiner joiner = new StringJoiner("\n  ", "Did not expect there to be any cleanup jobs still here. Jobs[", "]");
            this.consumeAndCloseJobs(cj -> joiner.add(this.jobs.toString()));
            throw new IllegalStateException(joiner.toString());
        }
    }

    @Override
    public void add(CleanupJob job) {
        this.jobs.add(job);
    }

    public void start() throws Throwable {
        this.jobScheduler.schedule(JobScheduler.Groups.recoveryCleanup, this.allJobs());
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
        this.consumeAndCloseJobs(cj -> {});
    }

    private Runnable allJobs() {
        return () -> this.executeWithExecutor(executor -> {
            CleanupJob job;
            while ((job = this.jobs.poll()) != null) {
                try {
                    job.run(executor);
                }
                finally {
                    job.close();
                }
            }
        });
    }

    private void consumeAndCloseJobs(Consumer<CleanupJob> consumer) {
        CleanupJob job;
        while ((job = this.jobs.poll()) != null) {
            consumer.accept(job);
            job.close();
        }
    }
}

