/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.GenerationSafePointer;
import org.neo4j.index.internal.gbptree.PageCursorUtil;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

class CrashGenerationCleaner {
    private static final long MIN_BATCH_SIZE = 10L;
    static final long MAX_BATCH_SIZE = 1000L;
    private final PagedFile pagedFile;
    private final TreeNode<?, ?> treeNode;
    private final long lowTreeNodeId;
    private final long highTreeNodeId;
    private final long stableGeneration;
    private final long unstableGeneration;
    private final GBPTree.Monitor monitor;
    private final long internalMaxKeyCount;

    CrashGenerationCleaner(PagedFile pagedFile, TreeNode<?, ?> treeNode, long lowTreeNodeId, long highTreeNodeId, long stableGeneration, long unstableGeneration, GBPTree.Monitor monitor) {
        this.pagedFile = pagedFile;
        this.treeNode = treeNode;
        this.lowTreeNodeId = lowTreeNodeId;
        this.highTreeNodeId = highTreeNodeId;
        this.stableGeneration = stableGeneration;
        this.unstableGeneration = unstableGeneration;
        this.monitor = monitor;
        this.internalMaxKeyCount = treeNode.internalMaxKeyCount();
    }

    static long batchSize(long pagesToClean, int threads) {
        return Math.min(1000L, Math.max(10L, pagesToClean / (long)(100 * threads)));
    }

    public void clean(ExecutorService executor) throws IOException {
        this.monitor.cleanupStarted();
        assert (this.unstableGeneration > this.stableGeneration) : this.unexpectedGenerations();
        assert (this.unstableGeneration - this.stableGeneration > 1L) : this.unexpectedGenerations();
        long startTime = System.currentTimeMillis();
        long pagesToClean = this.highTreeNodeId - this.lowTreeNodeId;
        int threads = Runtime.getRuntime().availableProcessors();
        long batchSize = CrashGenerationCleaner.batchSize(pagesToClean, threads);
        AtomicLong nextId = new AtomicLong(this.lowTreeNodeId);
        AtomicReference<Throwable> error = new AtomicReference<Throwable>();
        AtomicInteger cleanedPointers = new AtomicInteger();
        CountDownLatch activeThreadLatch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            executor.submit(this.cleaner(nextId, batchSize, cleanedPointers, activeThreadLatch, error));
        }
        try {
            long lastProgression = nextId.get();
            while (!activeThreadLatch.await(30L, TimeUnit.SECONDS)) {
                if (lastProgression == nextId.get()) {
                    error.compareAndSet(null, new IOException("No progress, so forcing abort"));
                }
                lastProgression = nextId.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Throwable finalError = (Throwable)error.get();
        if (finalError != null) {
            throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)finalError);
        }
        long endTime = System.currentTimeMillis();
        this.monitor.cleanupFinished(pagesToClean, cleanedPointers.get(), endTime - startTime);
    }

    private Runnable cleaner(AtomicLong nextId, long batchSize, AtomicInteger cleanedPointers, CountDownLatch activeThreadLatch, AtomicReference<Throwable> error) {
        return () -> {
            try (PageCursor cursor = this.pagedFile.io(0L, 1);
                 PageCursor writeCursor = this.pagedFile.io(0L, 2);){
                long localNextId;
                while ((localNextId = nextId.getAndAdd(batchSize)) < this.highTreeNodeId) {
                    int i = 0;
                    while ((long)i < batchSize && localNextId < this.highTreeNodeId) {
                        PageCursorUtil.goTo(cursor, "clean", localNextId);
                        if (this.hasCrashedGSPP(this.treeNode, cursor)) {
                            writeCursor.next(cursor.getCurrentPageId());
                            this.cleanTreeNode(this.treeNode, writeCursor, cleanedPointers);
                        }
                        ++i;
                        ++localNextId;
                    }
                    if (error.get() == null) continue;
                    break;
                }
            }
            catch (Throwable e) {
                error.accumulateAndGet(e, Exceptions::chain);
            }
            finally {
                activeThreadLatch.countDown();
            }
        };
    }

    private boolean hasCrashedGSPP(TreeNode<?, ?> treeNode, PageCursor cursor) throws IOException {
        boolean hasCrashed;
        int keyCount;
        boolean isTreeNode;
        do {
            isTreeNode = TreeNode.nodeType(cursor) == 1;
            keyCount = TreeNode.keyCount(cursor);
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        if (!isTreeNode) {
            return false;
        }
        do {
            boolean bl = hasCrashed = this.hasCrashedGSPP(cursor, 58) || this.hasCrashedGSPP(cursor, 34) || this.hasCrashedGSPP(cursor, 10);
            if (hasCrashed || !TreeNode.isInternal(cursor)) continue;
            for (int i = 0; i <= keyCount && (long)i <= this.internalMaxKeyCount && !hasCrashed; ++i) {
                hasCrashed = this.hasCrashedGSPP(cursor, treeNode.childOffset(i));
            }
        } while (cursor.shouldRetry());
        PageCursorUtil.checkOutOfBounds(cursor);
        return hasCrashed;
    }

    private boolean hasCrashedGSPP(PageCursor cursor, int gsppOffset) {
        return this.hasCrashedGSP(cursor, gsppOffset) || this.hasCrashedGSP(cursor, gsppOffset + 12);
    }

    private boolean hasCrashedGSP(PageCursor cursor, int offset) {
        cursor.setOffset(offset);
        long generation = GenerationSafePointer.readGeneration(cursor);
        return generation > this.stableGeneration && generation < this.unstableGeneration;
    }

    private void cleanTreeNode(TreeNode<?, ?> treeNode, PageCursor cursor, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSPP(cursor, 58, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 34, cleanedPointers);
        this.cleanCrashedGSPP(cursor, 10, cleanedPointers);
        if (TreeNode.isInternal(cursor)) {
            int keyCount = TreeNode.keyCount(cursor);
            for (int i = 0; i <= keyCount && (long)i <= this.internalMaxKeyCount; ++i) {
                this.cleanCrashedGSPP(cursor, treeNode.childOffset(i), cleanedPointers);
            }
        }
    }

    private void cleanCrashedGSPP(PageCursor cursor, int gsppOffset, AtomicInteger cleanedPointers) {
        this.cleanCrashedGSP(cursor, gsppOffset, cleanedPointers);
        this.cleanCrashedGSP(cursor, gsppOffset + 12, cleanedPointers);
    }

    private void cleanCrashedGSP(PageCursor cursor, int gspOffset, AtomicInteger cleanedPointers) {
        if (this.hasCrashedGSP(cursor, gspOffset)) {
            cursor.setOffset(gspOffset);
            GenerationSafePointer.clean(cursor);
            cleanedPointers.incrementAndGet();
        }
    }

    private String unexpectedGenerations() {
        return "Unexpected generations, stableGeneration=" + this.stableGeneration + ", unstableGeneration=" + this.unstableGeneration;
    }
}

