/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.CrashGenerationCleaner;
import org.neo4j.index.internal.gbptree.GBPTreeLock;

class GBPTreeCleanupJob
implements CleanupJob {
    private final CrashGenerationCleaner crashGenerationCleaner;
    private final GBPTreeLock gbpTreeLock;
    private volatile boolean needed;
    private volatile Exception failure;

    GBPTreeCleanupJob(CrashGenerationCleaner crashGenerationCleaner, GBPTreeLock gbpTreeLock) {
        this.crashGenerationCleaner = crashGenerationCleaner;
        this.gbpTreeLock = gbpTreeLock;
        this.needed = true;
    }

    @Override
    public boolean needed() {
        return this.needed;
    }

    @Override
    public boolean hasFailed() {
        return this.failure != null;
    }

    @Override
    public Exception getCause() {
        return this.failure;
    }

    @Override
    public void close() {
        this.gbpTreeLock.cleanerUnlock();
    }

    @Override
    public void run() {
        try {
            this.crashGenerationCleaner.clean();
            this.needed = false;
        }
        catch (Exception e) {
            this.failure = e;
        }
    }
}

