/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import org.neo4j.index.internal.gbptree.GenerationSafePointerPair;
import org.neo4j.index.internal.gbptree.TreeInconsistencyException;
import org.neo4j.index.internal.gbptree.TreeNode;
import org.neo4j.io.pagecache.PageCursor;

class PointerChecking {
    static final String WRITER_TRAVERSE_OLD_STATE_MESSAGE = "Writer traversed to a tree node that has a valid successor, This is most likely due to failure to checkpoint the tree before shutdown and/or tree state being out of date.";

    private PointerChecking() {
    }

    static void checkPointer(long result, boolean allowNoNode) {
        GenerationSafePointerPair.assertSuccess(result);
        if (allowNoNode && !TreeNode.isNode(result)) {
            return;
        }
        if (result < 3L) {
            throw new TreeInconsistencyException("Pointer to id " + result + " not allowed. Minimum node id allowed is " + 3L, new Object[0]);
        }
    }

    static void assertNoSuccessor(PageCursor cursor, long stableGeneration, long unstableGeneration) {
        long successor = TreeNode.successor(cursor, stableGeneration, unstableGeneration);
        if (TreeNode.isNode(successor)) {
            throw new TreeInconsistencyException(WRITER_TRAVERSE_OLD_STATE_MESSAGE, new Object[0]);
        }
    }
}

