/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.internal.gbptree;

import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.neo4j.index.internal.gbptree.CleanupJob;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.scheduler.JobScheduler;

public class GroupingRecoveryCleanupWorkCollector
implements RecoveryCleanupWorkCollector {
    private final Queue<CleanupJob> jobs;
    private final JobScheduler jobScheduler;

    public GroupingRecoveryCleanupWorkCollector(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
        this.jobs = new LinkedBlockingQueue<CleanupJob>();
    }

    public void init() throws Throwable {
        this.jobs.clear();
    }

    @Override
    public void add(CleanupJob job) {
        this.jobs.add(job);
    }

    public void start() throws Throwable {
        this.jobScheduler.schedule(JobScheduler.Groups.recoveryCleanup, this.allJobs());
    }

    public void stop() throws Throwable {
    }

    public void shutdown() throws Throwable {
    }

    private Runnable allJobs() {
        return () -> {
            CleanupJob job;
            while ((job = this.jobs.poll()) != null) {
                job.run();
            }
        };
    }
}

